
// We are modularizing this manually because the current modularize setting in Emscripten has some issues:
// https://github.com/kripken/emscripten/issues/5820
// In addition, When you use emcc's modularization, it still expects to export a global object called `Module`,
// which is able to be used/called before the WASM is loaded.
// The modularization below exports a promise that loads and resolves to the actual sql.js module.
// That way, this module can't be used before the WASM is finished loading.

// We are going to define a function that a user will call to start loading initializing our Sql.js library
// However, that function might be called multiple times, and on subsequent calls, we don't actually want it to instantiate a new instance of the Module
// Instead, we want to return the previously loaded module

// TODO: Make this not declare a global if used in the browser
var initSqlJsPromise = undefined;

var initSqlJs = function (moduleConfig) {

    if (initSqlJsPromise){
      return initSqlJsPromise;
    }
    // If we're here, we've never called this function before
    initSqlJsPromise = new Promise(function (resolveModule, reject) {

        // We are modularizing this manually because the current modularize setting in Emscripten has some issues:
        // https://github.com/kripken/emscripten/issues/5820

        // The way to affect the loading of emcc compiled modules is to create a variable called `Module` and add
        // properties to it, like `preRun`, `postRun`, etc
        // We are using that to get notified when the WASM has finished loading.
        // Only then will we return our promise

        // If they passed in a moduleConfig object, use that
        // Otherwise, initialize Module to the empty object
        var Module = typeof moduleConfig !== 'undefined' ? moduleConfig : {};

        // EMCC only allows for a single onAbort function (not an array of functions)
        // So if the user defined their own onAbort function, we remember it and call it
        var originalOnAbortFunction = Module['onAbort'];
        Module['onAbort'] = function (errorThatCausedAbort) {
            reject(new Error(errorThatCausedAbort));
            if (originalOnAbortFunction){
              originalOnAbortFunction(errorThatCausedAbort);
            }
        };

        Module['postRun'] = Module['postRun'] || [];
        Module['postRun'].push(function () {
            // When Emscripted calls postRun, this promise resolves with the built Module
            resolveModule(Module);
        });

        // There is a section of code in the emcc-generated code below that looks like this:
        // (Note that this is lowercase `module`)
        // if (typeof module !== 'undefined') {
        //     module['exports'] = Module;
        // }
        // When that runs, it's going to overwrite our own modularization export efforts in shell-post.js!
        // The only way to tell emcc not to emit it is to pass the MODULARIZE=1 or MODULARIZE_INSTANCE=1 flags,
        // but that carries with it additional unnecessary baggage/bugs we don't want either.
        // So, we have three options:
        // 1) We undefine `module`
        // 2) We remember what `module['exports']` was at the beginning of this function and we restore it later
        // 3) We write a script to remove those lines of code as part of the Make process.
        //
        // Since those are the only lines of code that care about module, we will undefine it. It's the most straightforward
        // of the options, and has the side effect of reducing emcc's efforts to modify the module if its output were to change in the future.
        // That's a nice side effect since we're handling the modularization efforts ourselves
        module = undefined;

        // The emcc-generated code and shell-post.js code goes below,
        // meaning that all of it runs inside of this promise. If anything throws an exception, our promise will abort
var f;f||=typeof Module != 'undefined' ? Module : {};var aa="object"==typeof window,ba="function"==typeof importScripts,ca="object"==typeof process&&"object"==typeof process.versions&&"string"==typeof process.versions.node;"use strict";
f.onRuntimeInitialized=function(){function a(g,l){switch(typeof l){case "boolean":fc(g,l?1:0);break;case "number":gc(g,l);break;case "string":hc(g,l,-1,-1);break;case "object":if(null===l)ib(g);else if(null!=l.length){var n=da(l,ea);ic(g,n,l.length,-1);fa(n)}else xa(g,"Wrong API use : tried to return a value of an unknown type ("+l+").",-1);break;default:ib(g)}}function b(g,l){for(var n=[],t=0;t<g;t+=1){var w=m(l+4*t,"i32"),A=jc(w);if(1===A||2===A)w=kc(w);else if(3===A)w=lc(w);else if(4===A){A=w;
w=mc(A);A=nc(A);for(var N=new Uint8Array(w),M=0;M<w;M+=1)N[M]=p[A+M];w=N}else w=null;n.push(w)}return n}function c(g,l){this.Ka=g;this.db=l;this.Ia=1;this.eb=[]}function d(g,l){this.db=l;l=ha(g)+1;this.Xa=ia(l);if(null===this.Xa)throw Error("Unable to allocate memory for the SQL string");q(g,u,this.Xa,l);this.cb=this.Xa;this.Ta=this.hb=null}function e(g){this.filename="dbfile_"+(4294967295*Math.random()>>>0);if(null!=g){var l=this.filename,n="/",t=l;n&&(n="string"==typeof n?n:ja(n),t=l?x(n+"/"+l):
n);l=ka(!0,!0);t=la(t,(void 0!==l?l:438)&4095|32768,0);if(g){if("string"==typeof g){n=Array(g.length);for(var w=0,A=g.length;w<A;++w)n[w]=g.charCodeAt(w);g=n}ma(t,l|146);n=na(t,577);oa(n,g,0,g.length,0);pa(n);ma(t,l)}}this.handleError(r(this.filename,h));this.db=m(h,"i32");lb(this.db);this.Ya={};this.Ma={}}var h=y(4),k=f.cwrap,r=k("sqlite3_open","number",["string","number"]),z=k("sqlite3_close_v2","number",["number"]),v=k("sqlite3_exec","number",["number","string","number","number","number"]),E=k("sqlite3_changes",
"number",["number"]),H=k("sqlite3_prepare_v2","number",["number","string","number","number","number"]),mb=k("sqlite3_sql","string",["number"]),oc=k("sqlite3_normalized_sql","string",["number"]),nb=k("sqlite3_prepare_v2","number",["number","number","number","number","number"]),pc=k("sqlite3_bind_text","number",["number","number","number","number","number"]),ob=k("sqlite3_bind_blob","number",["number","number","number","number","number"]),qc=k("sqlite3_bind_double","number",["number","number","number"]),
rc=k("sqlite3_bind_int","number",["number","number","number"]),sc=k("sqlite3_bind_parameter_index","number",["number","string"]),tc=k("sqlite3_step","number",["number"]),uc=k("sqlite3_errmsg","string",["number"]),vc=k("sqlite3_column_count","number",["number"]),wc=k("sqlite3_data_count","number",["number"]),xc=k("sqlite3_column_double","number",["number","number"]),pb=k("sqlite3_column_text","string",["number","number"]),yc=k("sqlite3_column_blob","number",["number","number"]),zc=k("sqlite3_column_bytes",
"number",["number","number"]),Ac=k("sqlite3_column_type","number",["number","number"]),Bc=k("sqlite3_column_name","string",["number","number"]),Cc=k("sqlite3_reset","number",["number"]),Dc=k("sqlite3_clear_bindings","number",["number"]),Ec=k("sqlite3_finalize","number",["number"]),qb=k("sqlite3_create_function_v2","number","number string number number number number number number number".split(" ")),jc=k("sqlite3_value_type","number",["number"]),mc=k("sqlite3_value_bytes","number",["number"]),lc=k("sqlite3_value_text",
"string",["number"]),nc=k("sqlite3_value_blob","number",["number"]),kc=k("sqlite3_value_double","number",["number"]),gc=k("sqlite3_result_double","",["number","number"]),ib=k("sqlite3_result_null","",["number"]),hc=k("sqlite3_result_text","",["number","string","number","number"]),ic=k("sqlite3_result_blob","",["number","number","number","number"]),fc=k("sqlite3_result_int","",["number","number"]),xa=k("sqlite3_result_error","",["number","string","number"]),rb=k("sqlite3_aggregate_context","number",
["number","number"]),lb=k("RegisterExtensionFunctions","number",["number"]);c.prototype.bind=function(g){if(!this.Ka)throw"Statement closed";this.reset();return Array.isArray(g)?this.vb(g):null!=g&&"object"===typeof g?this.wb(g):!0};c.prototype.step=function(){if(!this.Ka)throw"Statement closed";this.Ia=1;var g=tc(this.Ka);switch(g){case 100:return!0;case 101:return!1;default:throw this.db.handleError(g);}};c.prototype.qb=function(g){null==g&&(g=this.Ia,this.Ia+=1);return xc(this.Ka,g)};c.prototype.zb=
function(g){null==g&&(g=this.Ia,this.Ia+=1);g=pb(this.Ka,g);if("function"!==typeof BigInt)throw Error("BigInt is not supported");return BigInt(g)};c.prototype.Ab=function(g){null==g&&(g=this.Ia,this.Ia+=1);return pb(this.Ka,g)};c.prototype.getBlob=function(g){null==g&&(g=this.Ia,this.Ia+=1);var l=zc(this.Ka,g);g=yc(this.Ka,g);for(var n=new Uint8Array(l),t=0;t<l;t+=1)n[t]=p[g+t];return n};c.prototype.get=function(g,l){l=l||{};null!=g&&this.bind(g)&&this.step();g=[];for(var n=wc(this.Ka),t=0;t<n;t+=
1)switch(Ac(this.Ka,t)){case 1:var w=l.useBigInt?this.zb(t):this.qb(t);g.push(w);break;case 2:g.push(this.qb(t));break;case 3:g.push(this.Ab(t));break;case 4:g.push(this.getBlob(t));break;default:g.push(null)}return g};c.prototype.getColumnNames=function(){for(var g=[],l=vc(this.Ka),n=0;n<l;n+=1)g.push(Bc(this.Ka,n));return g};c.prototype.getAsObject=function(g,l){g=this.get(g,l);l=this.getColumnNames();for(var n={},t=0;t<l.length;t+=1)n[l[t]]=g[t];return n};c.prototype.getSQL=function(){return mb(this.Ka)};
c.prototype.getNormalizedSQL=function(){return oc(this.Ka)};c.prototype.run=function(g){null!=g&&this.bind(g);this.step();return this.reset()};c.prototype.mb=function(g,l){null==l&&(l=this.Ia,this.Ia+=1);g=qa(g);var n=da(g,ea);this.eb.push(n);this.db.handleError(pc(this.Ka,l,n,g.length-1,0))};c.prototype.ub=function(g,l){null==l&&(l=this.Ia,this.Ia+=1);var n=da(g,ea);this.eb.push(n);this.db.handleError(ob(this.Ka,l,n,g.length,0))};c.prototype.lb=function(g,l){null==l&&(l=this.Ia,this.Ia+=1);this.db.handleError((g===
(g|0)?rc:qc)(this.Ka,l,g))};c.prototype.xb=function(g){null==g&&(g=this.Ia,this.Ia+=1);ob(this.Ka,g,0,0,0)};c.prototype.nb=function(g,l){null==l&&(l=this.Ia,this.Ia+=1);switch(typeof g){case "string":this.mb(g,l);return;case "number":this.lb(g,l);return;case "bigint":this.mb(g.toString(),l);return;case "boolean":this.lb(g+0,l);return;case "object":if(null===g){this.xb(l);return}if(null!=g.length){this.ub(g,l);return}}throw"Wrong API use : tried to bind a value of an unknown type ("+g+").";};c.prototype.wb=
function(g){var l=this;Object.keys(g).forEach(function(n){var t=sc(l.Ka,n);0!==t&&l.nb(g[n],t)});return!0};c.prototype.vb=function(g){for(var l=0;l<g.length;l+=1)this.nb(g[l],l+1);return!0};c.prototype.reset=function(){this.freemem();return 0===Dc(this.Ka)&&0===Cc(this.Ka)};c.prototype.freemem=function(){for(var g;void 0!==(g=this.eb.pop());)fa(g)};c.prototype.free=function(){this.freemem();var g=0===Ec(this.Ka);delete this.db.Ya[this.Ka];this.Ka=0;return g};d.prototype.next=function(){if(null===
this.Xa)return{done:!0};null!==this.Ta&&(this.Ta.free(),this.Ta=null);if(!this.db.db)throw this.fb(),Error("Database closed");var g=ra(),l=y(4);sa(h);sa(l);try{this.db.handleError(nb(this.db.db,this.cb,-1,h,l));this.cb=m(l,"i32");var n=m(h,"i32");if(0===n)return this.fb(),{done:!0};this.Ta=new c(n,this.db);this.db.Ya[n]=this.Ta;return{value:this.Ta,done:!1}}catch(t){throw this.hb=ta(this.cb),this.fb(),t;}finally{ua(g)}};d.prototype.fb=function(){fa(this.Xa);this.Xa=null};d.prototype.getRemainingSQL=
function(){return null!==this.hb?this.hb:ta(this.cb)};"function"===typeof Symbol&&"symbol"===typeof Symbol.iterator&&(d.prototype[Symbol.iterator]=function(){return this});e.prototype.run=function(g,l){if(!this.db)throw"Database closed";if(l){g=this.prepare(g,l);try{g.step()}finally{g.free()}}else this.handleError(v(this.db,g,0,0,h));return this};e.prototype.exec=function(g,l,n){if(!this.db)throw"Database closed";var t=ra(),w=null;try{var A=va(g),N=y(4);for(g=[];0!==m(A,"i8");){sa(h);sa(N);this.handleError(nb(this.db,
A,-1,h,N));var M=m(h,"i32");A=m(N,"i32");if(0!==M){var K=null;w=new c(M,this);for(null!=l&&w.bind(l);w.step();)null===K&&(K={columns:w.getColumnNames(),values:[]},g.push(K)),K.values.push(w.get(null,n));w.free()}}return g}catch(O){throw w&&w.free(),O;}finally{ua(t)}};e.prototype.each=function(g,l,n,t,w){"function"===typeof l&&(t=n,n=l,l=void 0);g=this.prepare(g,l);try{for(;g.step();)n(g.getAsObject(null,w))}finally{g.free()}if("function"===typeof t)return t()};e.prototype.prepare=function(g,l){sa(h);
this.handleError(H(this.db,g,-1,h,0));g=m(h,"i32");if(0===g)throw"Nothing to prepare";var n=new c(g,this);null!=l&&n.bind(l);return this.Ya[g]=n};e.prototype.iterateStatements=function(g){return new d(g,this)};e.prototype["export"]=function(){Object.values(this.Ya).forEach(function(l){l.free()});Object.values(this.Ma).forEach(wa);this.Ma={};this.handleError(z(this.db));var g=ya(this.filename);this.handleError(r(this.filename,h));this.db=m(h,"i32");lb(this.db);return g};e.prototype.close=function(){null!==
this.db&&(Object.values(this.Ya).forEach(function(g){g.free()}),Object.values(this.Ma).forEach(wa),this.Ma={},this.handleError(z(this.db)),za("/"+this.filename),this.db=null)};e.prototype.handleError=function(g){if(0===g)return null;g=uc(this.db);throw Error(g);};e.prototype.getRowsModified=function(){return E(this.db)};e.prototype.create_function=function(g,l){Object.prototype.hasOwnProperty.call(this.Ma,g)&&(wa(this.Ma[g]),delete this.Ma[g]);var n=Aa(function(t,w,A){w=b(w,A);try{var N=l.apply(null,
w)}catch(M){xa(t,M,-1);return}a(t,N)},"viii");this.Ma[g]=n;this.handleError(qb(this.db,g,l.length,1,0,n,0,0,0));return this};e.prototype.create_aggregate=function(g,l){var n=l.init||function(){return null},t=l.finalize||function(K){return K},w=l.step;if(!w)throw"An aggregate function must have a step function in "+g;var A={};Object.hasOwnProperty.call(this.Ma,g)&&(wa(this.Ma[g]),delete this.Ma[g]);l=g+"__finalize";Object.hasOwnProperty.call(this.Ma,l)&&(wa(this.Ma[l]),delete this.Ma[l]);var N=Aa(function(K,
O,Ra){var Y=rb(K,1);Object.hasOwnProperty.call(A,Y)||(A[Y]=n());O=b(O,Ra);O=[A[Y]].concat(O);try{A[Y]=w.apply(null,O)}catch(Gc){delete A[Y],xa(K,Gc,-1)}},"viii"),M=Aa(function(K){var O=rb(K,1);try{var Ra=t(A[O])}catch(Y){delete A[O];xa(K,Y,-1);return}a(K,Ra);delete A[O]},"vi");this.Ma[g]=N;this.Ma[l]=M;this.handleError(qb(this.db,g,w.length-1,1,0,0,N,M,0));return this};f.Database=e};var Ba=Object.assign({},f),Ca="./this.program",B="",Da,Ea;
if(ca){var fs=require("fs"),Fa=require("path");B=__dirname+"/";Ea=a=>{a=Ga(a)?new URL(a):Fa.normalize(a);return fs.readFileSync(a)};Da=a=>{a=Ga(a)?new URL(a):Fa.normalize(a);return new Promise((b,c)=>{fs.readFile(a,void 0,(d,e)=>{d?c(d):b(e.buffer)})})};!f.thisProgram&&1<process.argv.length&&(Ca=process.argv[1].replace(/\\/g,"/"));process.argv.slice(2);"undefined"!=typeof module&&(module.exports=f)}else if(aa||ba)ba?B=self.location.href:"undefined"!=typeof document&&document.currentScript&&(B=document.currentScript.src),
B=B.startsWith("blob:")?"":B.substr(0,B.replace(/[?#].*/,"").lastIndexOf("/")+1),ba&&(Ea=a=>{var b=new XMLHttpRequest;b.open("GET",a,!1);b.responseType="arraybuffer";b.send(null);return new Uint8Array(b.response)}),Da=a=>Ga(a)?new Promise((b,c)=>{var d=new XMLHttpRequest;d.open("GET",a,!0);d.responseType="arraybuffer";d.onload=()=>{(200==d.status||0==d.status&&d.response)&&c(d.response);b(d.status)};d.onerror=b;d.send(null)}):fetch(a,{credentials:"same-origin"}).then(b=>b.ok?b.arrayBuffer():Promise.reject(Error(b.status+
" : "+b.url)));var Ha=f.print||console.log.bind(console),C=f.printErr||console.error.bind(console);Object.assign(f,Ba);Ba=null;f.thisProgram&&(Ca=f.thisProgram);var Ia;f.wasmBinary&&(Ia=f.wasmBinary);var Ja,Ka=!1,p,u,La,D,F,Ma,Na;
function Oa(){var a=Ja.buffer;f.HEAP8=p=new Int8Array(a);f.HEAP16=La=new Int16Array(a);f.HEAPU8=u=new Uint8Array(a);f.HEAPU16=new Uint16Array(a);f.HEAP32=D=new Int32Array(a);f.HEAPU32=F=new Uint32Array(a);f.HEAPF32=Ma=new Float32Array(a);f.HEAPF64=Na=new Float64Array(a)}var Pa=[],Qa=[],Sa=[];function Ta(){var a=f.preRun.shift();Pa.unshift(a)}var Ua=0,Va=null,Wa=null;
function G(a){f.onAbort?.(a);a="Aborted("+a+")";C(a);Ka=!0;throw new WebAssembly.RuntimeError(a+". Build with -sASSERTIONS for more info.");}var Xa=a=>a.startsWith("data:application/octet-stream;base64,"),Ga=a=>a.startsWith("file://"),Ya;function Za(a){if(a==Ya&&Ia)return new Uint8Array(Ia);if(Ea)return Ea(a);throw"both async and sync fetching of the wasm failed";}function $a(a){return Ia?Promise.resolve().then(()=>Za(a)):Da(a).then(b=>new Uint8Array(b),()=>Za(a))}
function ab(a,b,c){return $a(a).then(d=>WebAssembly.instantiate(d,b)).then(c,d=>{C(`failed to asynchronously prepare wasm: ${d}`);G(d)})}function bb(a,b){var c=Ya;Ia||"function"!=typeof WebAssembly.instantiateStreaming||Xa(c)||Ga(c)||ca||"function"!=typeof fetch?ab(c,a,b):fetch(c,{credentials:"same-origin"}).then(d=>WebAssembly.instantiateStreaming(d,a).then(b,function(e){C(`wasm streaming compile failed: ${e}`);C("falling back to ArrayBuffer instantiation");return ab(c,a,b)}))}
var I,J,cb=a=>{for(;0<a.length;)a.shift()(f)};function m(a,b="i8"){b.endsWith("*")&&(b="*");switch(b){case "i1":return p[a];case "i8":return p[a];case "i16":return La[a>>1];case "i32":return D[a>>2];case "i64":G("to do getValue(i64) use WASM_BIGINT");case "float":return Ma[a>>2];case "double":return Na[a>>3];case "*":return F[a>>2];default:G(`invalid type for getValue: ${b}`)}}
function sa(a){var b="i32";b.endsWith("*")&&(b="*");switch(b){case "i1":p[a]=0;break;case "i8":p[a]=0;break;case "i16":La[a>>1]=0;break;case "i32":D[a>>2]=0;break;case "i64":G("to do setValue(i64) use WASM_BIGINT");case "float":Ma[a>>2]=0;break;case "double":Na[a>>3]=0;break;case "*":F[a>>2]=0;break;default:G(`invalid type for setValue: ${b}`)}}
var db="undefined"!=typeof TextDecoder?new TextDecoder:void 0,L=(a,b,c)=>{var d=b+c;for(c=b;a[c]&&!(c>=d);)++c;if(16<c-b&&a.buffer&&db)return db.decode(a.subarray(b,c));for(d="";b<c;){var e=a[b++];if(e&128){var h=a[b++]&63;if(192==(e&224))d+=String.fromCharCode((e&31)<<6|h);else{var k=a[b++]&63;e=224==(e&240)?(e&15)<<12|h<<6|k:(e&7)<<18|h<<12|k<<6|a[b++]&63;65536>e?d+=String.fromCharCode(e):(e-=65536,d+=String.fromCharCode(55296|e>>10,56320|e&1023))}}else d+=String.fromCharCode(e)}return d},ta=(a,
b)=>a?L(u,a,b):"",eb=(a,b)=>{for(var c=0,d=a.length-1;0<=d;d--){var e=a[d];"."===e?a.splice(d,1):".."===e?(a.splice(d,1),c++):c&&(a.splice(d,1),c--)}if(b)for(;c;c--)a.unshift("..");return a},x=a=>{var b="/"===a.charAt(0),c="/"===a.substr(-1);(a=eb(a.split("/").filter(d=>!!d),!b).join("/"))||b||(a=".");a&&c&&(a+="/");return(b?"/":"")+a},fb=a=>{var b=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/.exec(a).slice(1);a=b[0];b=b[1];if(!a&&!b)return".";b&&=b.substr(0,b.length-1);return a+
b},gb=a=>{if("/"===a)return"/";a=x(a);a=a.replace(/\/$/,"");var b=a.lastIndexOf("/");return-1===b?a:a.substr(b+1)},hb=()=>{if("object"==typeof crypto&&"function"==typeof crypto.getRandomValues)return c=>crypto.getRandomValues(c);if(ca)try{var a=require("crypto");if(a.randomFillSync)return c=>a.randomFillSync(c);var b=a.randomBytes;return c=>(c.set(b(c.byteLength)),c)}catch(c){}G("initRandomDevice")},jb=a=>(jb=hb())(a),kb=(...a)=>{for(var b="",c=!1,d=a.length-1;-1<=d&&!c;d--){c=0<=d?a[d]:"/";if("string"!=
typeof c)throw new TypeError("Arguments to path.resolve must be strings");if(!c)return"";b=c+"/"+b;c="/"===c.charAt(0)}b=eb(b.split("/").filter(e=>!!e),!c).join("/");return(c?"/":"")+b||"."},sb=[],ha=a=>{for(var b=0,c=0;c<a.length;++c){var d=a.charCodeAt(c);127>=d?b++:2047>=d?b+=2:55296<=d&&57343>=d?(b+=4,++c):b+=3}return b},q=(a,b,c,d)=>{if(!(0<d))return 0;var e=c;d=c+d-1;for(var h=0;h<a.length;++h){var k=a.charCodeAt(h);if(55296<=k&&57343>=k){var r=a.charCodeAt(++h);k=65536+((k&1023)<<10)|r&1023}if(127>=
k){if(c>=d)break;b[c++]=k}else{if(2047>=k){if(c+1>=d)break;b[c++]=192|k>>6}else{if(65535>=k){if(c+2>=d)break;b[c++]=224|k>>12}else{if(c+3>=d)break;b[c++]=240|k>>18;b[c++]=128|k>>12&63}b[c++]=128|k>>6&63}b[c++]=128|k&63}}b[c]=0;return c-e};function qa(a,b){var c=Array(ha(a)+1);a=q(a,c,0,c.length);b&&(c.length=a);return c}var tb=[];function ub(a,b){tb[a]={input:[],output:[],Wa:b};vb(a,wb)}
var wb={open(a){var b=tb[a.node.rdev];if(!b)throw new P(43);a.tty=b;a.seekable=!1},close(a){a.tty.Wa.fsync(a.tty)},fsync(a){a.tty.Wa.fsync(a.tty)},read(a,b,c,d){if(!a.tty||!a.tty.Wa.rb)throw new P(60);for(var e=0,h=0;h<d;h++){try{var k=a.tty.Wa.rb(a.tty)}catch(r){throw new P(29);}if(void 0===k&&0===e)throw new P(6);if(null===k||void 0===k)break;e++;b[c+h]=k}e&&(a.node.timestamp=Date.now());return e},write(a,b,c,d){if(!a.tty||!a.tty.Wa.ib)throw new P(60);try{for(var e=0;e<d;e++)a.tty.Wa.ib(a.tty,b[c+
e])}catch(h){throw new P(29);}d&&(a.node.timestamp=Date.now());return e}},xb={rb(){a:{if(!sb.length){var a=null;if(ca){var b=Buffer.alloc(256),c=0,d=process.stdin.fd;try{c=fs.readSync(d,b,0,256)}catch(e){if(e.toString().includes("EOF"))c=0;else throw e;}0<c&&(a=b.slice(0,c).toString("utf-8"))}else"undefined"!=typeof window&&"function"==typeof window.prompt&&(a=window.prompt("Input: "),null!==a&&(a+="\n"));if(!a){a=null;break a}sb=qa(a,!0)}a=sb.shift()}return a},ib(a,b){null===b||10===b?(Ha(L(a.output,
0)),a.output=[]):0!=b&&a.output.push(b)},fsync(a){a.output&&0<a.output.length&&(Ha(L(a.output,0)),a.output=[])},Lb(){return{Gb:25856,Ib:5,Fb:191,Hb:35387,Eb:[3,28,127,21,4,0,1,0,17,19,26,0,18,15,23,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]}},Mb(){return 0},Nb(){return[24,80]}},yb={ib(a,b){null===b||10===b?(C(L(a.output,0)),a.output=[]):0!=b&&a.output.push(b)},fsync(a){a.output&&0<a.output.length&&(C(L(a.output,0)),a.output=[])}};
function zb(a,b){var c=a.Ha?a.Ha.length:0;c>=b||(b=Math.max(b,c*(1048576>c?2:1.125)>>>0),0!=c&&(b=Math.max(b,256)),c=a.Ha,a.Ha=new Uint8Array(b),0<a.La&&a.Ha.set(c.subarray(0,a.La),0))}
var Q={Pa:null,Qa(){return Q.createNode(null,"/",16895,0)},createNode(a,b,c,d){if(24576===(c&61440)||4096===(c&61440))throw new P(63);Q.Pa||(Q.Pa={dir:{node:{Oa:Q.Fa.Oa,Na:Q.Fa.Na,lookup:Q.Fa.lookup,$a:Q.Fa.$a,rename:Q.Fa.rename,unlink:Q.Fa.unlink,rmdir:Q.Fa.rmdir,readdir:Q.Fa.readdir,symlink:Q.Fa.symlink},stream:{Sa:Q.Ga.Sa}},file:{node:{Oa:Q.Fa.Oa,Na:Q.Fa.Na},stream:{Sa:Q.Ga.Sa,read:Q.Ga.read,write:Q.Ga.write,kb:Q.Ga.kb,ab:Q.Ga.ab,bb:Q.Ga.bb}},link:{node:{Oa:Q.Fa.Oa,Na:Q.Fa.Na,readlink:Q.Fa.readlink},
stream:{}},ob:{node:{Oa:Q.Fa.Oa,Na:Q.Fa.Na},stream:Ab}});c=Bb(a,b,c,d);R(c.mode)?(c.Fa=Q.Pa.dir.node,c.Ga=Q.Pa.dir.stream,c.Ha={}):32768===(c.mode&61440)?(c.Fa=Q.Pa.file.node,c.Ga=Q.Pa.file.stream,c.La=0,c.Ha=null):40960===(c.mode&61440)?(c.Fa=Q.Pa.link.node,c.Ga=Q.Pa.link.stream):8192===(c.mode&61440)&&(c.Fa=Q.Pa.ob.node,c.Ga=Q.Pa.ob.stream);c.timestamp=Date.now();a&&(a.Ha[b]=c,a.timestamp=c.timestamp);return c},Kb(a){return a.Ha?a.Ha.subarray?a.Ha.subarray(0,a.La):new Uint8Array(a.Ha):new Uint8Array(0)},
Fa:{Oa(a){var b={};b.dev=8192===(a.mode&61440)?a.id:1;b.ino=a.id;b.mode=a.mode;b.nlink=1;b.uid=0;b.gid=0;b.rdev=a.rdev;R(a.mode)?b.size=4096:32768===(a.mode&61440)?b.size=a.La:40960===(a.mode&61440)?b.size=a.link.length:b.size=0;b.atime=new Date(a.timestamp);b.mtime=new Date(a.timestamp);b.ctime=new Date(a.timestamp);b.yb=4096;b.blocks=Math.ceil(b.size/b.yb);return b},Na(a,b){void 0!==b.mode&&(a.mode=b.mode);void 0!==b.timestamp&&(a.timestamp=b.timestamp);if(void 0!==b.size&&(b=b.size,a.La!=b))if(0==
b)a.Ha=null,a.La=0;else{var c=a.Ha;a.Ha=new Uint8Array(b);c&&a.Ha.set(c.subarray(0,Math.min(b,a.La)));a.La=b}},lookup(){throw Cb[44];},$a(a,b,c,d){return Q.createNode(a,b,c,d)},rename(a,b,c){if(R(a.mode)){try{var d=Db(b,c)}catch(h){}if(d)for(var e in d.Ha)throw new P(55);}delete a.parent.Ha[a.name];a.parent.timestamp=Date.now();a.name=c;b.Ha[c]=a;b.timestamp=a.parent.timestamp},unlink(a,b){delete a.Ha[b];a.timestamp=Date.now()},rmdir(a,b){var c=Db(a,b),d;for(d in c.Ha)throw new P(55);delete a.Ha[b];
a.timestamp=Date.now()},readdir(a){var b=[".",".."],c;for(c of Object.keys(a.Ha))b.push(c);return b},symlink(a,b,c){a=Q.createNode(a,b,41471,0);a.link=c;return a},readlink(a){if(40960!==(a.mode&61440))throw new P(28);return a.link}},Ga:{read(a,b,c,d,e){var h=a.node.Ha;if(e>=a.node.La)return 0;a=Math.min(a.node.La-e,d);if(8<a&&h.subarray)b.set(h.subarray(e,e+a),c);else for(d=0;d<a;d++)b[c+d]=h[e+d];return a},write(a,b,c,d,e,h){b.buffer===p.buffer&&(h=!1);if(!d)return 0;a=a.node;a.timestamp=Date.now();
if(b.subarray&&(!a.Ha||a.Ha.subarray)){if(h)return a.Ha=b.subarray(c,c+d),a.La=d;if(0===a.La&&0===e)return a.Ha=b.slice(c,c+d),a.La=d;if(e+d<=a.La)return a.Ha.set(b.subarray(c,c+d),e),d}zb(a,e+d);if(a.Ha.subarray&&b.subarray)a.Ha.set(b.subarray(c,c+d),e);else for(h=0;h<d;h++)a.Ha[e+h]=b[c+h];a.La=Math.max(a.La,e+d);return d},Sa(a,b,c){1===c?b+=a.position:2===c&&32768===(a.node.mode&61440)&&(b+=a.node.La);if(0>b)throw new P(28);return b},kb(a,b,c){zb(a.node,b+c);a.node.La=Math.max(a.node.La,b+c)},
ab(a,b,c,d,e){if(32768!==(a.node.mode&61440))throw new P(43);a=a.node.Ha;if(e&2||a.buffer!==p.buffer){if(0<c||c+b<a.length)a.subarray?a=a.subarray(c,c+b):a=Array.prototype.slice.call(a,c,c+b);c=!0;b=65536*Math.ceil(b/65536);(e=Eb(65536,b))?(u.fill(0,e,e+b),b=e):b=0;if(!b)throw new P(48);p.set(a,b)}else c=!1,b=a.byteOffset;return{Cb:b,tb:c}},bb(a,b,c,d){Q.Ga.write(a,b,0,d,c,!1);return 0}}},ka=(a,b)=>{var c=0;a&&(c|=365);b&&(c|=146);return c},Fb=null,Gb={},Hb=[],Ib=1,S=null,Jb=!0,P=class{constructor(a){this.name=
"ErrnoError";this.Ja=a}},Cb={},Kb=class{constructor(){this.Za={};this.node=null}get flags(){return this.Za.flags}set flags(a){this.Za.flags=a}get position(){return this.Za.position}set position(a){this.Za.position=a}},Lb=class{constructor(a,b,c,d){a||=this;this.parent=a;this.Qa=a.Qa;this.Ua=null;this.id=Ib++;this.name=b;this.mode=c;this.Fa={};this.Ga={};this.rdev=d}get read(){return 365===(this.mode&365)}set read(a){a?this.mode|=365:this.mode&=-366}get write(){return 146===(this.mode&146)}set write(a){a?
this.mode|=146:this.mode&=-147}};function T(a,b={}){a=kb(a);if(!a)return{path:"",node:null};b=Object.assign({pb:!0,jb:0},b);if(8<b.jb)throw new P(32);a=a.split("/").filter(k=>!!k);for(var c=Fb,d="/",e=0;e<a.length;e++){var h=e===a.length-1;if(h&&b.parent)break;c=Db(c,a[e]);d=x(d+"/"+a[e]);c.Ua&&(!h||h&&b.pb)&&(c=c.Ua.root);if(!h||b.Ra)for(h=0;40960===(c.mode&61440);)if(c=Mb(d),d=kb(fb(d),c),c=T(d,{jb:b.jb+1}).node,40<h++)throw new P(32);}return{path:d,node:c}}
function ja(a){for(var b;;){if(a===a.parent)return a=a.Qa.sb,b?"/"!==a[a.length-1]?`${a}/${b}`:a+b:a;b=b?`${a.name}/${b}`:a.name;a=a.parent}}function Nb(a,b){for(var c=0,d=0;d<b.length;d++)c=(c<<5)-c+b.charCodeAt(d)|0;return(a+c>>>0)%S.length}function Ob(a){var b=Nb(a.parent.id,a.name);if(S[b]===a)S[b]=a.Va;else for(b=S[b];b;){if(b.Va===a){b.Va=a.Va;break}b=b.Va}}
function Db(a,b){var c=R(a.mode)?(c=Pb(a,"x"))?c:a.Fa.lookup?0:2:54;if(c)throw new P(c);for(c=S[Nb(a.id,b)];c;c=c.Va){var d=c.name;if(c.parent.id===a.id&&d===b)return c}return a.Fa.lookup(a,b)}function Bb(a,b,c,d){a=new Lb(a,b,c,d);b=Nb(a.parent.id,a.name);a.Va=S[b];return S[b]=a}function R(a){return 16384===(a&61440)}function Qb(a){var b=["r","w","rw"][a&3];a&512&&(b+="w");return b}
function Pb(a,b){if(Jb)return 0;if(!b.includes("r")||a.mode&292){if(b.includes("w")&&!(a.mode&146)||b.includes("x")&&!(a.mode&73))return 2}else return 2;return 0}function Rb(a,b){try{return Db(a,b),20}catch(c){}return Pb(a,"wx")}function Sb(a,b,c){try{var d=Db(a,b)}catch(e){return e.Ja}if(a=Pb(a,"wx"))return a;if(c){if(!R(d.mode))return 54;if(d===d.parent||"/"===ja(d))return 10}else if(R(d.mode))return 31;return 0}function U(a){a=Hb[a];if(!a)throw new P(8);return a}
function Tb(a,b=-1){a=Object.assign(new Kb,a);if(-1==b)a:{for(b=0;4096>=b;b++)if(!Hb[b])break a;throw new P(33);}a.fd=b;return Hb[b]=a}function Ub(a,b=-1){a=Tb(a,b);a.Ga?.Jb?.(a);return a}var Ab={open(a){a.Ga=Gb[a.node.rdev].Ga;a.Ga.open?.(a)},Sa(){throw new P(70);}};function vb(a,b){Gb[a]={Ga:b}}
function Vb(a,b){var c="/"===b;if(c&&Fb)throw new P(10);if(!c&&b){var d=T(b,{pb:!1});b=d.path;d=d.node;if(d.Ua)throw new P(10);if(!R(d.mode))throw new P(54);}b={type:a,Ob:{},sb:b,Bb:[]};a=a.Qa(b);a.Qa=b;b.root=a;c?Fb=a:d&&(d.Ua=b,d.Qa&&d.Qa.Bb.push(b))}function la(a,b,c){var d=T(a,{parent:!0}).node;a=gb(a);if(!a||"."===a||".."===a)throw new P(28);var e=Rb(d,a);if(e)throw new P(e);if(!d.Fa.$a)throw new P(63);return d.Fa.$a(d,a,b,c)}function V(a,b){return la(a,(void 0!==b?b:511)&1023|16384,0)}
function Wb(a,b,c){"undefined"==typeof c&&(c=b,b=438);la(a,b|8192,c)}function Xb(a,b){if(!kb(a))throw new P(44);var c=T(b,{parent:!0}).node;if(!c)throw new P(44);b=gb(b);var d=Rb(c,b);if(d)throw new P(d);if(!c.Fa.symlink)throw new P(63);c.Fa.symlink(c,b,a)}function Yb(a){var b=T(a,{parent:!0}).node;a=gb(a);var c=Db(b,a),d=Sb(b,a,!0);if(d)throw new P(d);if(!b.Fa.rmdir)throw new P(63);if(c.Ua)throw new P(10);b.Fa.rmdir(b,a);Ob(c)}
function za(a){var b=T(a,{parent:!0}).node;if(!b)throw new P(44);a=gb(a);var c=Db(b,a),d=Sb(b,a,!1);if(d)throw new P(d);if(!b.Fa.unlink)throw new P(63);if(c.Ua)throw new P(10);b.Fa.unlink(b,a);Ob(c)}function Mb(a){a=T(a).node;if(!a)throw new P(44);if(!a.Fa.readlink)throw new P(28);return kb(ja(a.parent),a.Fa.readlink(a))}function Zb(a,b){a=T(a,{Ra:!b}).node;if(!a)throw new P(44);if(!a.Fa.Oa)throw new P(63);return a.Fa.Oa(a)}function $b(a){return Zb(a,!0)}
function ma(a,b){a="string"==typeof a?T(a,{Ra:!0}).node:a;if(!a.Fa.Na)throw new P(63);a.Fa.Na(a,{mode:b&4095|a.mode&-4096,timestamp:Date.now()})}function ac(a,b){if(0>b)throw new P(28);a="string"==typeof a?T(a,{Ra:!0}).node:a;if(!a.Fa.Na)throw new P(63);if(R(a.mode))throw new P(31);if(32768!==(a.mode&61440))throw new P(28);var c=Pb(a,"w");if(c)throw new P(c);a.Fa.Na(a,{size:b,timestamp:Date.now()})}
function na(a,b,c){if(""===a)throw new P(44);if("string"==typeof b){var d={r:0,"r+":2,w:577,"w+":578,a:1089,"a+":1090}[b];if("undefined"==typeof d)throw Error(`Unknown file open mode: ${b}`);b=d}c=b&64?("undefined"==typeof c?438:c)&4095|32768:0;if("object"==typeof a)var e=a;else{a=x(a);try{e=T(a,{Ra:!(b&131072)}).node}catch(h){}}d=!1;if(b&64)if(e){if(b&128)throw new P(20);}else e=la(a,c,0),d=!0;if(!e)throw new P(44);8192===(e.mode&61440)&&(b&=-513);if(b&65536&&!R(e.mode))throw new P(54);if(!d&&(c=
e?40960===(e.mode&61440)?32:R(e.mode)&&("r"!==Qb(b)||b&512)?31:Pb(e,Qb(b)):44))throw new P(c);b&512&&!d&&ac(e,0);b&=-131713;e=Tb({node:e,path:ja(e),flags:b,seekable:!0,position:0,Ga:e.Ga,Db:[],error:!1});e.Ga.open&&e.Ga.open(e);!f.logReadFiles||b&1||(bc||={},a in bc||(bc[a]=1));return e}function pa(a){if(null===a.fd)throw new P(8);a.gb&&(a.gb=null);try{a.Ga.close&&a.Ga.close(a)}catch(b){throw b;}finally{Hb[a.fd]=null}a.fd=null}
function cc(a,b,c){if(null===a.fd)throw new P(8);if(!a.seekable||!a.Ga.Sa)throw new P(70);if(0!=c&&1!=c&&2!=c)throw new P(28);a.position=a.Ga.Sa(a,b,c);a.Db=[]}function dc(a,b,c,d,e){if(0>d||0>e)throw new P(28);if(null===a.fd)throw new P(8);if(1===(a.flags&2097155))throw new P(8);if(R(a.node.mode))throw new P(31);if(!a.Ga.read)throw new P(28);var h="undefined"!=typeof e;if(!h)e=a.position;else if(!a.seekable)throw new P(70);b=a.Ga.read(a,b,c,d,e);h||(a.position+=b);return b}
function oa(a,b,c,d,e){if(0>d||0>e)throw new P(28);if(null===a.fd)throw new P(8);if(0===(a.flags&2097155))throw new P(8);if(R(a.node.mode))throw new P(31);if(!a.Ga.write)throw new P(28);a.seekable&&a.flags&1024&&cc(a,0,2);var h="undefined"!=typeof e;if(!h)e=a.position;else if(!a.seekable)throw new P(70);b=a.Ga.write(a,b,c,d,e,void 0);h||(a.position+=b);return b}
function ya(a){var b="binary";if("utf8"!==b&&"binary"!==b)throw Error(`Invalid encoding type "${b}"`);var c;var d=na(a,d||0);a=Zb(a).size;var e=new Uint8Array(a);dc(d,e,0,a,0);"utf8"===b?c=L(e,0):"binary"===b&&(c=e);pa(d);return c}var ec;
function Fc(a,b,c){a=x("/dev/"+a);var d=ka(!!b,!!c);Hc||=64;var e=Hc++<<8|0;vb(e,{open(h){h.seekable=!1},close(){c?.buffer?.length&&c(10)},read(h,k,r,z){for(var v=0,E=0;E<z;E++){try{var H=b()}catch(mb){throw new P(29);}if(void 0===H&&0===v)throw new P(6);if(null===H||void 0===H)break;v++;k[r+E]=H}v&&(h.node.timestamp=Date.now());return v},write(h,k,r,z){for(var v=0;v<z;v++)try{c(k[r+v])}catch(E){throw new P(29);}z&&(h.node.timestamp=Date.now());return v}});Wb(a,d,e)}var Hc,W={},bc;
function Ic(a,b,c){if("/"===b.charAt(0))return b;a=-100===a?"/":U(a).path;if(0==b.length){if(!c)throw new P(44);return a}return x(a+"/"+b)}
function Jc(a,b,c){a=a(b);D[c>>2]=a.dev;D[c+4>>2]=a.mode;F[c+8>>2]=a.nlink;D[c+12>>2]=a.uid;D[c+16>>2]=a.gid;D[c+20>>2]=a.rdev;J=[a.size>>>0,(I=a.size,1<=+Math.abs(I)?0<I?+Math.floor(I/4294967296)>>>0:~~+Math.ceil((I-+(~~I>>>0))/4294967296)>>>0:0)];D[c+24>>2]=J[0];D[c+28>>2]=J[1];D[c+32>>2]=4096;D[c+36>>2]=a.blocks;b=a.atime.getTime();var d=a.mtime.getTime(),e=a.ctime.getTime();J=[Math.floor(b/1E3)>>>0,(I=Math.floor(b/1E3),1<=+Math.abs(I)?0<I?+Math.floor(I/4294967296)>>>0:~~+Math.ceil((I-+(~~I>>>
0))/4294967296)>>>0:0)];D[c+40>>2]=J[0];D[c+44>>2]=J[1];F[c+48>>2]=b%1E3*1E3;J=[Math.floor(d/1E3)>>>0,(I=Math.floor(d/1E3),1<=+Math.abs(I)?0<I?+Math.floor(I/4294967296)>>>0:~~+Math.ceil((I-+(~~I>>>0))/4294967296)>>>0:0)];D[c+56>>2]=J[0];D[c+60>>2]=J[1];F[c+64>>2]=d%1E3*1E3;J=[Math.floor(e/1E3)>>>0,(I=Math.floor(e/1E3),1<=+Math.abs(I)?0<I?+Math.floor(I/4294967296)>>>0:~~+Math.ceil((I-+(~~I>>>0))/4294967296)>>>0:0)];D[c+72>>2]=J[0];D[c+76>>2]=J[1];F[c+80>>2]=e%1E3*1E3;J=[a.ino>>>0,(I=a.ino,1<=+Math.abs(I)?
0<I?+Math.floor(I/4294967296)>>>0:~~+Math.ceil((I-+(~~I>>>0))/4294967296)>>>0:0)];D[c+88>>2]=J[0];D[c+92>>2]=J[1];return 0}var Kc=void 0;function Lc(){var a=D[+Kc>>2];Kc+=4;return a}
var Mc=(a,b)=>b+2097152>>>0<4194305-!!a?(a>>>0)+4294967296*b:NaN,Nc=[0,31,60,91,121,152,182,213,244,274,305,335],Oc=[0,31,59,90,120,151,181,212,243,273,304,334],Pc={},Rc=()=>{if(!Qc){var a={USER:"web_user",LOGNAME:"web_user",PATH:"/",PWD:"/",HOME:"/home/web_user",LANG:("object"==typeof navigator&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8",_:Ca||"./this.program"},b;for(b in Pc)void 0===Pc[b]?delete a[b]:a[b]=Pc[b];var c=[];for(b in a)c.push(`${b}=${a[b]}`);Qc=c}return Qc},
Qc,va=a=>{var b=ha(a)+1,c=y(b);q(a,u,c,b);return c},Sc=(a,b,c,d)=>{var e={string:v=>{var E=0;null!==v&&void 0!==v&&0!==v&&(E=va(v));return E},array:v=>{var E=y(v.length);p.set(v,E);return E}};a=f["_"+a];var h=[],k=0;if(d)for(var r=0;r<d.length;r++){var z=e[c[r]];z?(0===k&&(k=ra()),h[r]=z(d[r])):h[r]=d[r]}c=a(...h);return c=function(v){0!==k&&ua(k);return"string"===b?v?L(u,v):"":"boolean"===b?!!v:v}(c)},ea=0,da=(a,b)=>{b=1==b?y(a.length):ia(a.length);a.subarray||a.slice||(a=new Uint8Array(a));u.set(a,
b);return b},Tc,Uc=[],X,wa=a=>{Tc.delete(X.get(a));X.set(a,null);Uc.push(a)},Aa=(a,b)=>{if(!Tc){Tc=new WeakMap;var c=X.length;if(Tc)for(var d=0;d<0+c;d++){var e=X.get(d);e&&Tc.set(e,d)}}if(c=Tc.get(a)||0)return c;if(Uc.length)c=Uc.pop();else{try{X.grow(1)}catch(r){if(!(r instanceof RangeError))throw r;throw"Unable to grow wasm table. Set ALLOW_TABLE_GROWTH.";}c=X.length-1}try{X.set(c,a)}catch(r){if(!(r instanceof TypeError))throw r;if("function"==typeof WebAssembly.Function){d=WebAssembly.Function;
e={i:"i32",j:"i64",f:"f32",d:"f64",e:"externref",p:"i32"};for(var h={parameters:[],results:"v"==b[0]?[]:[e[b[0]]]},k=1;k<b.length;++k)h.parameters.push(e[b[k]]);b=new d(h,a)}else{d=[1];e=b.slice(0,1);b=b.slice(1);h={i:127,p:127,j:126,f:125,d:124,e:111};d.push(96);k=b.length;128>k?d.push(k):d.push(k%128|128,k>>7);for(k=0;k<b.length;++k)d.push(h[b[k]]);"v"==e?d.push(0):d.push(1,h[e]);b=[0,97,115,109,1,0,0,0,1];e=d.length;128>e?b.push(e):b.push(e%128|128,e>>7);b.push(...d);b.push(2,7,1,1,101,1,102,0,
0,7,5,1,1,102,0,0);b=new WebAssembly.Module(new Uint8Array(b));b=(new WebAssembly.Instance(b,{e:{f:a}})).exports.f}X.set(c,b)}Tc.set(a,c);return c};[44].forEach(a=>{Cb[a]=new P(a);Cb[a].stack="<generic error, no stack>"});S=Array(4096);Vb(Q,"/");V("/tmp");V("/home");V("/home/web_user");
(function(){V("/dev");vb(259,{read:()=>0,write:(d,e,h,k)=>k});Wb("/dev/null",259);ub(1280,xb);ub(1536,yb);Wb("/dev/tty",1280);Wb("/dev/tty1",1536);var a=new Uint8Array(1024),b=0,c=()=>{0===b&&(b=jb(a).byteLength);return a[--b]};Fc("random",c);Fc("urandom",c);V("/dev/shm");V("/dev/shm/tmp")})();
(function(){V("/proc");var a=V("/proc/self");V("/proc/self/fd");Vb({Qa(){var b=Bb(a,"fd",16895,73);b.Fa={lookup(c,d){var e=U(+d);c={parent:null,Qa:{sb:"fake"},Fa:{readlink:()=>e.path}};return c.parent=c}};return b}},"/proc/self/fd")})();
var Vc={a:(a,b,c,d)=>{G(`Assertion failed: ${a?L(u,a):""}, at: `+[b?b?L(u,b):"":"unknown filename",c,d?d?L(u,d):"":"unknown function"])},h:function(a,b){try{return a=a?L(u,a):"",ma(a,b),0}catch(c){if("undefined"==typeof W||"ErrnoError"!==c.name)throw c;return-c.Ja}},H:function(a,b,c){try{b=b?L(u,b):"";b=Ic(a,b);if(c&-8)return-28;var d=T(b,{Ra:!0}).node;if(!d)return-44;a="";c&4&&(a+="r");c&2&&(a+="w");c&1&&(a+="x");return a&&Pb(d,a)?-2:0}catch(e){if("undefined"==typeof W||"ErrnoError"!==e.name)throw e;
return-e.Ja}},i:function(a,b){try{var c=U(a);ma(c.node,b);return 0}catch(d){if("undefined"==typeof W||"ErrnoError"!==d.name)throw d;return-d.Ja}},g:function(a){try{var b=U(a).node;var c="string"==typeof b?T(b,{Ra:!0}).node:b;if(!c.Fa.Na)throw new P(63);c.Fa.Na(c,{timestamp:Date.now()});return 0}catch(d){if("undefined"==typeof W||"ErrnoError"!==d.name)throw d;return-d.Ja}},b:function(a,b,c){Kc=c;try{var d=U(a);switch(b){case 0:var e=Lc();if(0>e)break;for(;Hb[e];)e++;return Ub(d,e).fd;case 1:case 2:return 0;
case 3:return d.flags;case 4:return e=Lc(),d.flags|=e,0;case 12:return e=Lc(),La[e+0>>1]=2,0;case 13:case 14:return 0}return-28}catch(h){if("undefined"==typeof W||"ErrnoError"!==h.name)throw h;return-h.Ja}},f:function(a,b){try{var c=U(a);return Jc(Zb,c.path,b)}catch(d){if("undefined"==typeof W||"ErrnoError"!==d.name)throw d;return-d.Ja}},n:function(a,b,c){b=Mc(b,c);try{if(isNaN(b))return 61;var d=U(a);if(0===(d.flags&2097155))throw new P(28);ac(d.node,b);return 0}catch(e){if("undefined"==typeof W||
"ErrnoError"!==e.name)throw e;return-e.Ja}},C:function(a,b){try{if(0===b)return-28;var c=ha("/")+1;if(b<c)return-68;q("/",u,a,b);return c}catch(d){if("undefined"==typeof W||"ErrnoError"!==d.name)throw d;return-d.Ja}},F:function(a,b){try{return a=a?L(u,a):"",Jc($b,a,b)}catch(c){if("undefined"==typeof W||"ErrnoError"!==c.name)throw c;return-c.Ja}},z:function(a,b,c){try{return b=b?L(u,b):"",b=Ic(a,b),b=x(b),"/"===b[b.length-1]&&(b=b.substr(0,b.length-1)),V(b,c),0}catch(d){if("undefined"==typeof W||"ErrnoError"!==
d.name)throw d;return-d.Ja}},E:function(a,b,c,d){try{b=b?L(u,b):"";var e=d&256;b=Ic(a,b,d&4096);return Jc(e?$b:Zb,b,c)}catch(h){if("undefined"==typeof W||"ErrnoError"!==h.name)throw h;return-h.Ja}},x:function(a,b,c,d){Kc=d;try{b=b?L(u,b):"";b=Ic(a,b);var e=d?Lc():0;return na(b,c,e).fd}catch(h){if("undefined"==typeof W||"ErrnoError"!==h.name)throw h;return-h.Ja}},v:function(a,b,c,d){try{b=b?L(u,b):"";b=Ic(a,b);if(0>=d)return-28;var e=Mb(b),h=Math.min(d,ha(e)),k=p[c+h];q(e,u,c,d+1);p[c+h]=k;return h}catch(r){if("undefined"==
typeof W||"ErrnoError"!==r.name)throw r;return-r.Ja}},u:function(a){try{return a=a?L(u,a):"",Yb(a),0}catch(b){if("undefined"==typeof W||"ErrnoError"!==b.name)throw b;return-b.Ja}},G:function(a,b){try{return a=a?L(u,a):"",Jc(Zb,a,b)}catch(c){if("undefined"==typeof W||"ErrnoError"!==c.name)throw c;return-c.Ja}},r:function(a,b,c){try{return b=b?L(u,b):"",b=Ic(a,b),0===c?za(b):512===c?Yb(b):G("Invalid flags passed to unlinkat"),0}catch(d){if("undefined"==typeof W||"ErrnoError"!==d.name)throw d;return-d.Ja}},
q:function(a,b,c){try{b=b?L(u,b):"";b=Ic(a,b,!0);if(c){var d=F[c>>2]+4294967296*D[c+4>>2],e=D[c+8>>2];h=1E3*d+e/1E6;c+=16;d=F[c>>2]+4294967296*D[c+4>>2];e=D[c+8>>2];k=1E3*d+e/1E6}else var h=Date.now(),k=h;a=h;var r=T(b,{Ra:!0}).node;r.Fa.Na(r,{timestamp:Math.max(a,k)});return 0}catch(z){if("undefined"==typeof W||"ErrnoError"!==z.name)throw z;return-z.Ja}},l:function(a,b,c){a=new Date(1E3*Mc(a,b));D[c>>2]=a.getSeconds();D[c+4>>2]=a.getMinutes();D[c+8>>2]=a.getHours();D[c+12>>2]=a.getDate();D[c+16>>
2]=a.getMonth();D[c+20>>2]=a.getFullYear()-1900;D[c+24>>2]=a.getDay();b=a.getFullYear();D[c+28>>2]=(0!==b%4||0===b%100&&0!==b%400?Oc:Nc)[a.getMonth()]+a.getDate()-1|0;D[c+36>>2]=-(60*a.getTimezoneOffset());b=(new Date(a.getFullYear(),6,1)).getTimezoneOffset();var d=(new Date(a.getFullYear(),0,1)).getTimezoneOffset();D[c+32>>2]=(b!=d&&a.getTimezoneOffset()==Math.min(d,b))|0},j:function(a,b,c,d,e,h,k,r){e=Mc(e,h);try{if(isNaN(e))return 61;var z=U(d);if(0!==(b&2)&&0===(c&2)&&2!==(z.flags&2097155))throw new P(2);
if(1===(z.flags&2097155))throw new P(2);if(!z.Ga.ab)throw new P(43);var v=z.Ga.ab(z,a,e,b,c);var E=v.Cb;D[k>>2]=v.tb;F[r>>2]=E;return 0}catch(H){if("undefined"==typeof W||"ErrnoError"!==H.name)throw H;return-H.Ja}},k:function(a,b,c,d,e,h,k){h=Mc(h,k);try{var r=U(e);if(c&2){if(32768!==(r.node.mode&61440))throw new P(43);if(!(d&2)){var z=u.slice(a,a+b);r.Ga.bb&&r.Ga.bb(r,z,h,b,d)}}}catch(v){if("undefined"==typeof W||"ErrnoError"!==v.name)throw v;return-v.Ja}},y:(a,b,c,d)=>{var e=(new Date).getFullYear(),
h=(new Date(e,0,1)).getTimezoneOffset();e=(new Date(e,6,1)).getTimezoneOffset();F[a>>2]=60*Math.max(h,e);D[b>>2]=Number(h!=e);b=k=>{var r=Math.abs(k);return`UTC${0<=k?"-":"+"}${String(Math.floor(r/60)).padStart(2,"0")}${String(r%60).padStart(2,"0")}`};a=b(h);b=b(e);e<h?(q(a,u,c,17),q(b,u,d,17)):(q(a,u,d,17),q(b,u,c,17))},d:()=>Date.now(),s:()=>2147483648,c:()=>performance.now(),o:a=>{var b=u.length;a>>>=0;if(2147483648<a)return!1;for(var c=1;4>=c;c*=2){var d=b*(1+.2/c);d=Math.min(d,a+100663296);var e=
Math;d=Math.max(a,d);a:{e=(e.min.call(e,2147483648,d+(65536-d%65536)%65536)-Ja.buffer.byteLength+65535)/65536;try{Ja.grow(e);Oa();var h=1;break a}catch(k){}h=void 0}if(h)return!0}return!1},A:(a,b)=>{var c=0;Rc().forEach((d,e)=>{var h=b+c;e=F[a+4*e>>2]=h;for(h=0;h<d.length;++h)p[e++]=d.charCodeAt(h);p[e]=0;c+=d.length+1});return 0},B:(a,b)=>{var c=Rc();F[a>>2]=c.length;var d=0;c.forEach(e=>d+=e.length+1);F[b>>2]=d;return 0},e:function(a){try{var b=U(a);pa(b);return 0}catch(c){if("undefined"==typeof W||
"ErrnoError"!==c.name)throw c;return c.Ja}},p:function(a,b){try{var c=U(a);p[b]=c.tty?2:R(c.mode)?3:40960===(c.mode&61440)?7:4;La[b+2>>1]=0;J=[0,(I=0,1<=+Math.abs(I)?0<I?+Math.floor(I/4294967296)>>>0:~~+Math.ceil((I-+(~~I>>>0))/4294967296)>>>0:0)];D[b+8>>2]=J[0];D[b+12>>2]=J[1];J=[0,(I=0,1<=+Math.abs(I)?0<I?+Math.floor(I/4294967296)>>>0:~~+Math.ceil((I-+(~~I>>>0))/4294967296)>>>0:0)];D[b+16>>2]=J[0];D[b+20>>2]=J[1];return 0}catch(d){if("undefined"==typeof W||"ErrnoError"!==d.name)throw d;return d.Ja}},
w:function(a,b,c,d){try{a:{var e=U(a);a=b;for(var h,k=b=0;k<c;k++){var r=F[a>>2],z=F[a+4>>2];a+=8;var v=dc(e,p,r,z,h);if(0>v){var E=-1;break a}b+=v;if(v<z)break;"undefined"!=typeof h&&(h+=v)}E=b}F[d>>2]=E;return 0}catch(H){if("undefined"==typeof W||"ErrnoError"!==H.name)throw H;return H.Ja}},m:function(a,b,c,d,e){b=Mc(b,c);try{if(isNaN(b))return 61;var h=U(a);cc(h,b,d);J=[h.position>>>0,(I=h.position,1<=+Math.abs(I)?0<I?+Math.floor(I/4294967296)>>>0:~~+Math.ceil((I-+(~~I>>>0))/4294967296)>>>0:0)];
D[e>>2]=J[0];D[e+4>>2]=J[1];h.gb&&0===b&&0===d&&(h.gb=null);return 0}catch(k){if("undefined"==typeof W||"ErrnoError"!==k.name)throw k;return k.Ja}},D:function(a){try{var b=U(a);return b.Ga?.fsync?b.Ga.fsync(b):0}catch(c){if("undefined"==typeof W||"ErrnoError"!==c.name)throw c;return c.Ja}},t:function(a,b,c,d){try{a:{var e=U(a);a=b;for(var h,k=b=0;k<c;k++){var r=F[a>>2],z=F[a+4>>2];a+=8;var v=oa(e,p,r,z,h);if(0>v){var E=-1;break a}b+=v;"undefined"!=typeof h&&(h+=v)}E=b}F[d>>2]=E;return 0}catch(H){if("undefined"==
typeof W||"ErrnoError"!==H.name)throw H;return H.Ja}}},Z=function(){function a(c){Z=c.exports;Ja=Z.I;Oa();X=Z.K;Qa.unshift(Z.J);Ua--;f.monitorRunDependencies?.(Ua);0==Ua&&(null!==Va&&(clearInterval(Va),Va=null),Wa&&(c=Wa,Wa=null,c()));return Z}var b={a:Vc};Ua++;f.monitorRunDependencies?.(Ua);if(f.instantiateWasm)try{return f.instantiateWasm(b,a)}catch(c){return C(`Module.instantiateWasm callback failed with error: ${c}`),!1}Ya||=Xa("sql-wasm.wasm")?"sql-wasm.wasm":f.locateFile?f.locateFile("sql-wasm.wasm",
B):B+"sql-wasm.wasm";bb(b,function(c){a(c.instance)});return{}}();f._sqlite3_free=a=>(f._sqlite3_free=Z.L)(a);f._sqlite3_value_text=a=>(f._sqlite3_value_text=Z.M)(a);f._sqlite3_prepare_v2=(a,b,c,d,e)=>(f._sqlite3_prepare_v2=Z.N)(a,b,c,d,e);f._sqlite3_step=a=>(f._sqlite3_step=Z.O)(a);f._sqlite3_reset=a=>(f._sqlite3_reset=Z.P)(a);f._sqlite3_exec=(a,b,c,d,e)=>(f._sqlite3_exec=Z.Q)(a,b,c,d,e);f._sqlite3_finalize=a=>(f._sqlite3_finalize=Z.R)(a);
f._sqlite3_column_name=(a,b)=>(f._sqlite3_column_name=Z.S)(a,b);f._sqlite3_column_text=(a,b)=>(f._sqlite3_column_text=Z.T)(a,b);f._sqlite3_column_type=(a,b)=>(f._sqlite3_column_type=Z.U)(a,b);f._sqlite3_errmsg=a=>(f._sqlite3_errmsg=Z.V)(a);f._sqlite3_clear_bindings=a=>(f._sqlite3_clear_bindings=Z.W)(a);f._sqlite3_value_blob=a=>(f._sqlite3_value_blob=Z.X)(a);f._sqlite3_value_bytes=a=>(f._sqlite3_value_bytes=Z.Y)(a);f._sqlite3_value_double=a=>(f._sqlite3_value_double=Z.Z)(a);
f._sqlite3_value_int=a=>(f._sqlite3_value_int=Z._)(a);f._sqlite3_value_type=a=>(f._sqlite3_value_type=Z.$)(a);f._sqlite3_result_blob=(a,b,c,d)=>(f._sqlite3_result_blob=Z.aa)(a,b,c,d);f._sqlite3_result_double=(a,b)=>(f._sqlite3_result_double=Z.ba)(a,b);f._sqlite3_result_error=(a,b,c)=>(f._sqlite3_result_error=Z.ca)(a,b,c);f._sqlite3_result_int=(a,b)=>(f._sqlite3_result_int=Z.da)(a,b);f._sqlite3_result_int64=(a,b,c)=>(f._sqlite3_result_int64=Z.ea)(a,b,c);
f._sqlite3_result_null=a=>(f._sqlite3_result_null=Z.fa)(a);f._sqlite3_result_text=(a,b,c,d)=>(f._sqlite3_result_text=Z.ga)(a,b,c,d);f._sqlite3_aggregate_context=(a,b)=>(f._sqlite3_aggregate_context=Z.ha)(a,b);f._sqlite3_column_count=a=>(f._sqlite3_column_count=Z.ia)(a);f._sqlite3_data_count=a=>(f._sqlite3_data_count=Z.ja)(a);f._sqlite3_column_blob=(a,b)=>(f._sqlite3_column_blob=Z.ka)(a,b);f._sqlite3_column_bytes=(a,b)=>(f._sqlite3_column_bytes=Z.la)(a,b);
f._sqlite3_column_double=(a,b)=>(f._sqlite3_column_double=Z.ma)(a,b);f._sqlite3_bind_blob=(a,b,c,d,e)=>(f._sqlite3_bind_blob=Z.na)(a,b,c,d,e);f._sqlite3_bind_double=(a,b,c)=>(f._sqlite3_bind_double=Z.oa)(a,b,c);f._sqlite3_bind_int=(a,b,c)=>(f._sqlite3_bind_int=Z.pa)(a,b,c);f._sqlite3_bind_text=(a,b,c,d,e)=>(f._sqlite3_bind_text=Z.qa)(a,b,c,d,e);f._sqlite3_bind_parameter_index=(a,b)=>(f._sqlite3_bind_parameter_index=Z.ra)(a,b);f._sqlite3_sql=a=>(f._sqlite3_sql=Z.sa)(a);
f._sqlite3_normalized_sql=a=>(f._sqlite3_normalized_sql=Z.ta)(a);f._sqlite3_changes=a=>(f._sqlite3_changes=Z.ua)(a);f._sqlite3_close_v2=a=>(f._sqlite3_close_v2=Z.va)(a);f._sqlite3_create_function_v2=(a,b,c,d,e,h,k,r,z)=>(f._sqlite3_create_function_v2=Z.wa)(a,b,c,d,e,h,k,r,z);f._sqlite3_open=(a,b)=>(f._sqlite3_open=Z.xa)(a,b);var ia=f._malloc=a=>(ia=f._malloc=Z.ya)(a),fa=f._free=a=>(fa=f._free=Z.za)(a);f._RegisterExtensionFunctions=a=>(f._RegisterExtensionFunctions=Z.Aa)(a);
var Eb=(a,b)=>(Eb=Z.Ba)(a,b),ua=a=>(ua=Z.Ca)(a),y=a=>(y=Z.Da)(a),ra=()=>(ra=Z.Ea)();f.stackSave=()=>ra();f.stackRestore=a=>ua(a);f.stackAlloc=a=>y(a);f.cwrap=(a,b,c,d)=>{var e=!c||c.every(h=>"number"===h||"boolean"===h);return"string"!==b&&e&&!d?f["_"+a]:(...h)=>Sc(a,b,c,h)};f.addFunction=Aa;f.removeFunction=wa;f.UTF8ToString=ta;f.ALLOC_NORMAL=ea;f.allocate=da;f.allocateUTF8OnStack=va;var Wc;Wa=function Xc(){Wc||Yc();Wc||(Wa=Xc)};
function Yc(){function a(){if(!Wc&&(Wc=!0,f.calledRun=!0,!Ka)){f.noFSInit||ec||(ec=!0,f.stdin=f.stdin,f.stdout=f.stdout,f.stderr=f.stderr,f.stdin?Fc("stdin",f.stdin):Xb("/dev/tty","/dev/stdin"),f.stdout?Fc("stdout",null,f.stdout):Xb("/dev/tty","/dev/stdout"),f.stderr?Fc("stderr",null,f.stderr):Xb("/dev/tty1","/dev/stderr"),na("/dev/stdin",0),na("/dev/stdout",1),na("/dev/stderr",1));Jb=!1;cb(Qa);f.onRuntimeInitialized?.();if(f.postRun)for("function"==typeof f.postRun&&(f.postRun=[f.postRun]);f.postRun.length;){var b=
f.postRun.shift();Sa.unshift(b)}cb(Sa)}}if(!(0<Ua)){if(f.preRun)for("function"==typeof f.preRun&&(f.preRun=[f.preRun]);f.preRun.length;)Ta();cb(Pa);0<Ua||(f.setStatus?(f.setStatus("Running..."),setTimeout(function(){setTimeout(function(){f.setStatus("")},1);a()},1)):a())}}if(f.preInit)for("function"==typeof f.preInit&&(f.preInit=[f.preInit]);0<f.preInit.length;)f.preInit.pop()();Yc();


        // The shell-pre.js and emcc-generated code goes above
        return Module;
    }); // The end of the promise being returned

  return initSqlJsPromise;
} // The end of our initSqlJs function

// This bit below is copied almost exactly from what you get when you use the MODULARIZE=1 flag with emcc
// However, we don't want to use the emcc modularization. See shell-pre.js
if (typeof exports === 'object' && typeof module === 'object'){
    module.exports = initSqlJs;
    // This will allow the module to be used in ES6 or CommonJS
    module.exports.default = initSqlJs;
}
else if (typeof define === 'function' && define['amd']) {
    define([], function() { return initSqlJs; });
}
else if (typeof exports === 'object'){
    exports["Module"] = initSqlJs;
}
/* global initSqlJs */
/* eslint-env worker */
/* eslint no-restricted-globals: ["error"] */

"use strict";

var db;

function onModuleReady(SQL) {
    function createDb(data) {
        if (db != null) db.close();
        db = new SQL.Database(data);
        return db;
    }

    var buff; var data; var result;
    data = this["data"];
    var config = data["config"] ? data["config"] : {};
    switch (data && data["action"]) {
        case "open":
            buff = data["buffer"];
            createDb(buff && new Uint8Array(buff));
            return postMessage({
                id: data["id"],
                ready: true
            });
        case "exec":
            if (db === null) {
                createDb();
            }
            if (!data["sql"]) {
                throw "exec: Missing query string";
            }
            return postMessage({
                id: data["id"],
                results: db.exec(data["sql"], data["params"], config)
            });
        case "getRowsModified":
            return postMessage({
                id: data["id"],
                rowsModified: db.getRowsModified()
            });
        case "each":
            if (db === null) {
                createDb();
            }
            var callback = function callback(row) {
                return postMessage({
                    id: data["id"],
                    row: row,
                    finished: false
                });
            };
            var done = function done() {
                return postMessage({
                    id: data["id"],
                    finished: true
                });
            };
            return db.each(data["sql"], data["params"], callback, done, config);
        case "export":
            buff = db["export"]();
            result = {
                id: data["id"],
                buffer: buff
            };
            try {
                return postMessage(result, [result]);
            } catch (error) {
                return postMessage(result);
            }
        case "close":
            if (db) {
                db.close();
            }
            return postMessage({
                id: data["id"]
            });
        default:
            throw new Error("Invalid action : " + (data && data["action"]));
    }
}

function onError(err) {
    return postMessage({
        id: this["data"]["id"],
        error: err["message"]
    });
}

if (typeof importScripts === "function") {
    db = null;
    var sqlModuleReady = initSqlJs();
    self.onmessage = function onmessage(event) {
        return sqlModuleReady
            .then(onModuleReady.bind(event))
            .catch(onError.bind(event));
    };
}
