const mysql = require('mysql2/promise'); // Use promise-based MySQL
require('dotenv').config(); // Load environment variables

const pool = mysql.createPool({
  host: process.env.DB_HOST || 'localhost',
  user: process.env.DB_USER || 'root',
  password: process.env.DB_PASSWORD || '',
  database: process.env.DB_NAME || 'tribal_arena',
  waitForConnections: true,
  connectionLimit: 10,
});

module.exports = pool;
