CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50),
    email VARCHAR(100),
    password_hash VARCHAR(255),
    profile_picture VARCHAR(255),
    genre VARCHAR(50)
);

CREATE TABLE battles (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100),
    type ENUM('direct', 'community', 'monthly'),
    status ENUM('live', 'voting', 'completed'),
    start_time DATETIME,
    end_time DATETIME
);

CREATE TABLE participants (
    id INT AUTO_INCREMENT PRIMARY KEY,
    battle_id INT,
    user_id INT,
    score INT DEFAULT 0,
    round INT,
    FOREIGN KEY (battle_id) REFERENCES battles(id),
    FOREIGN KEY (user_id) REFERENCES users(id)
);

CREATE TABLE votes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    battle_id INT,
    voter_id INT,
    participant_id INT,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (battle_id) REFERENCES battles(id),
    FOREIGN KEY (voter_id) REFERENCES users(id),
    FOREIGN KEY (participant_id) REFERENCES participants(id)
);

CREATE TABLE leaderboards (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT,
    total_wins INT DEFAULT 0,
    total_fire_ratings INT DEFAULT 0,
    last_updated DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id)
);
