const express = require('express');
const db = require('../db/connection');
const router = express.Router();

// Get leaderboard data
router.get('/', async (req, res) => {
    try {
        const [rows] = await db.query(
            'SELECT u.username, l.total_wins, l.total_fire_ratings FROM leaderboards l JOIN users u ON l.user_id = u.id ORDER BY l.total_fire_ratings DESC'
        );
        res.json(rows);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
});

module.exports = router;
