const express = require('express');
const db = require('../db/connection');
const router = express.Router();

// Cast a vote
router.post('/', async (req, res) => {
    const { battle_id, voter_id, participant_id } = req.body;
    try {
        await db.query(
            'INSERT INTO votes (battle_id, voter_id, participant_id) VALUES (?, ?, ?)',
            [battle_id, voter_id, participant_id]
        );
        res.status(201).json({ message: 'Vote cast successfully' });
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
});

module.exports = router;
