import initSqlJs from 'sql.js';

export async function initDatabase() {
  const SQL = await initSqlJs({
    locateFile: file => `/node_modules/sql.js/dist/${file}`
  });
  const db = new SQL.Database();

  // Create the 'users' table
  db.run(`
    CREATE TABLE IF NOT EXISTS users (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      username TEXT UNIQUE NOT NULL,
      email TEXT UNIQUE NOT NULL,
      password TEXT NOT NULL
    );
  `);

  // Create the 'challenges' table
  db.run(`
    CREATE TABLE IF NOT EXISTS challenges (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      challenger_id INTEGER NOT NULL,
      challenged_id INTEGER NOT NULL,
      beat_url TEXT,
      duration TEXT,
      name TEXT,
      message TEXT,
      status TEXT DEFAULT 'pending',
      timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,
      FOREIGN KEY (challenger_id) REFERENCES users(id),
      FOREIGN KEY (challenged_id) REFERENCES users(id)
    );
  `);

  // Create the 'battles' table
  db.run(`
    CREATE TABLE IF NOT EXISTS battles (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      challenge_id INTEGER UNIQUE NOT NULL,
      start_time DATETIME DEFAULT CURRENT_TIMESTAMP,
      end_time DATETIME,
      FOREIGN KEY (challenge_id) REFERENCES challenges(id)
    );
  `);

  // Create the 'votes' table
  db.run(`
    CREATE TABLE IF NOT EXISTS votes (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      battle_id INTEGER NOT NULL,
      user_id INTEGER NOT NULL,
      producer_id INTEGER NOT NULL,
      timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,
      FOREIGN KEY (battle_id) REFERENCES battles(id),
      FOREIGN KEY (user_id) REFERENCES users(id),
      FOREIGN KEY (producer_id) REFERENCES users(id)
    );
  `);

  // Create the 'leaderboard' table
  db.run(`
    CREATE TABLE IF NOT EXISTS leaderboard (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      user_id INTEGER UNIQUE NOT NULL,
      total_wins INTEGER DEFAULT 0,
      battles_participated INTEGER DEFAULT 0,
      win_rate REAL DEFAULT 0,
      FOREIGN KEY (user_id) REFERENCES users(id)
    );
  `);

  // Create the 'themes' table
  db.run(`
    CREATE TABLE IF NOT EXISTS themes (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      name TEXT UNIQUE NOT NULL,
      description TEXT,
      start_date DATETIME,
      end_date DATETIME
    );
  `);

  // Create the 'badges' table
  db.run(`
    CREATE TABLE IF NOT EXISTS badges (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      name TEXT UNIQUE NOT NULL,
      description TEXT,
      icon_url TEXT
    );
  `);

  // Create the 'user_badges' table
  db.run(`
    CREATE TABLE IF NOT EXISTS user_badges (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      user_id INTEGER NOT NULL,
      badge_id INTEGER NOT NULL,
      timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,
      FOREIGN KEY (user_id) REFERENCES users(id),
      FOREIGN KEY (badge_id) REFERENCES badges(id)
    );
  `);

  // Create the 'wallpapers' table
  db.run(`
    CREATE TABLE IF NOT EXISTS wallpapers (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      url TEXT UNIQUE NOT NULL,
      name TEXT,
      active INTEGER DEFAULT 0
    );
  `);

  console.log('Database initialized.');
  return db;
}
