import React, { useState } from 'react';
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import Sidebar from './components/Sidebar';
import Navbar from './components/Navbar';
import BattleArena from './components/battles/BattleArena';
import Studio from './components/studio/Studio';
import BattleDetails from './components/battles/BattleDetails'; // Import the new component
import './App.css';

function App() {
  const [isSidebarOpen, setIsSidebarOpen] = useState(true);

  return (
    <Router>
      <div className={`app ${isSidebarOpen ? '' : 'sidebar-closed'}`}>
        <Sidebar isOpen={isSidebarOpen} />
        <div className="main-container">
          <Navbar onMenuClick={() => setIsSidebarOpen(!isSidebarOpen)} isSidebarOpen={isSidebarOpen} />
          <main className="content">
            <Routes>
              <Route path="/" element={<div>Home Page</div>} />
              <Route path="/tribal-arena" element={<BattleArena />} />
              <Route path="/studio" element={<Studio />} />
              <Route path="/feed" element={<div>Feed Page</div>} />
              <Route path="/marketplace" element={<div>Marketplace Page</div>} />
              <Route path="/community" element={<div>Community Page</div>} />
              <Route path="/battle/:id" element={<BattleDetails />} /> {/* New route */}
            </Routes>
          </main>
        </div>
      </div>
    </Router>
  );
}

export default App;
