import React from 'react'
import './MainContent.css'

function MainContent() {
  const genres = [
    { name: 'Hip Hop', active: 12 },
    { name: 'R&B', active: 8 },
    { name: 'Trap', active: 15 },
    { name: 'Lo-Fi', active: 6 }
  ]

  return (
    <div className="main-content">
      <div className="genre-list">
        {genres.map(genre => (
          <div key={genre.name} className="genre-item">
            <div className="genre-name">{genre.name}</div>
            <div className="genre-active">{genre.active} active</div>
          </div>
        ))}
      </div>

      <div className="battle-section">
        <div className="section-header">
          <h2>Beat Battle Challenge</h2>
          <p>Start a new battle or join an existing one</p>
          <button className="start-challenge-btn">Start Challenge</button>
        </div>

        <div className="challenge-types">
          <div className="challenge-type">
            <h3>Direct Challenge</h3>
            <p>Challenge a specific producer to a <span className="highlight">1v1</span> battle</p>
          </div>
          <div className="challenge-type">
            <h3>Community Battle</h3>
            <p>Open challenge for <span className="highlight">all</span> producers to join</p>
          </div>
          <div className="challenge-type">
            <h3>Tournament</h3>
            <p>Enter a bracket-style competition</p>
          </div>
        </div>

        <div className="active-battles">
          <div className="battle-card">
            <div className="battle-header">
              <h3>Summer Beats Battle</h3>
              <div className="battle-tags">
                <span className="tag">Community Battle</span>
                <span className="tag">Hip Hop</span>
                <span className="tag live">LIVE</span>
              </div>
            </div>
            <div className="battle-stats">
              <span>1:00:00</span>
              <span>1234 watching</span>
              <span>567 likes</span>
            </div>
            <div className="battle-footer">
              <span>8 participants</span>
              <button className="join-battle-btn">Join Battle</button>
            </div>
          </div>

          <div className="battle-card">
            <div className="battle-header">
              <h3>Producer Showdown</h3>
              <div className="battle-tags">
                <span className="tag">Direct Challenge</span>
                <span className="tag">Trap</span>
                <span className="tag live">LIVE</span>
              </div>
            </div>
            <div className="battle-stats">
              <span>2:00:00</span>
              <span>856 watching</span>
              <span>234 likes</span>
            </div>
            <div className="battle-footer">
              <span>2 participants</span>
              <button className="join-battle-btn">Join Battle</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}

export default MainContent
