import React, { useState } from 'react'
import { useNavigate } from 'react-router-dom'
import { FaBars } from 'react-icons/fa'
import { IoNotifications } from 'react-icons/io5'
import { AiOutlineMail } from 'react-icons/ai'
import { IoMdSettings } from 'react-icons/io'
import './Navbar.css'

function Navbar({ onMenuClick, isSidebarOpen }) {
  const navigate = useNavigate()
  const [activeDropdown, setActiveDropdown] = useState(null)

  const navItems = {
    'Home': { path: '/', items: null },
    'Tribal Arena': {
      path: '/tribal-arena',
      items: [
        { label: 'Direct Challenge', path: '/tribal-arena/direct' },
        { label: 'Community Battles', path: '/tribal-arena/community' },
        { label: 'Leaderboards', path: '/tribal-arena/leaderboards' },
        { label: 'Monthly Challenges', path: '/tribal-arena/monthly' }
      ]
    },
    'Studio': { path: '/studio', items: null },
    'Feed': { path: '/feed', items: null },
    'Sponsorships': {
      path: '/sponsorships',
      items: [
        { label: 'Sponsor Portal', path: '/sponsorships/portal' },
        { label: 'Sponsored Battles', path: '/sponsorships/battles' }
      ]
    },
    'Marketplace': { path: '/marketplace', items: null },
    'Community': { path: '/community', items: null }
  }

  const handleNavigation = (path) => {
    navigate(path)
    setActiveDropdown(null)
  }

  return (
    <nav className="navbar">
      <button className="menu-button" onClick={onMenuClick}>
        <FaBars />
      </button>
      <div className={`nav-left ${!isSidebarOpen ? 'sidebar-closed' : ''}`}>
        <h1>THE BEAT TRIBE</h1>
      </div>
      <div className="nav-center">
        {Object.entries(navItems).map(([label, { path, items }]) => (
          <div
            key={label}
            className={`nav-item ${items ? 'has-dropdown' : ''}`}
            onMouseEnter={() => items && setActiveDropdown(label)}
            onMouseLeave={() => setActiveDropdown(null)}
          >
            <a 
              href="#"
              className={`nav-link ${activeDropdown === label ? 'active' : ''}`}
              onClick={(e) => {
                e.preventDefault()
                handleNavigation(path)
              }}
            >
              {label}
            </a>
            {items && activeDropdown === label && (
              <div className="dropdown-menu">
                {items.map((item) => (
                  <a
                    key={item.label}
                    href="#"
                    className="dropdown-item"
                    onClick={(e) => {
                      e.preventDefault()
                      handleNavigation(item.path)
                    }}
                  >
                    {item.label}
                  </a>
                ))}
              </div>
            )}
          </div>
        ))}
      </div>
      <div className="nav-right">
        <IoNotifications className="nav-icon" />
        <AiOutlineMail className="nav-icon" />
        <IoMdSettings className="nav-icon" />
        <div className="user-profile">
          <img src="https://via.placeholder.com/32" alt="User" />
          <span>Username</span>
        </div>
      </div>
    </nav>
  )
}

export default Navbar
