import React, { useState } from 'react'
import { useNavigate } from 'react-router-dom'
import { AiFillHome, AiOutlineTrophy, AiFillStar } from 'react-icons/ai'
import { BsMusicNote, BsPeople } from 'react-icons/bs'
import { MdLeaderboard, MdFavorite } from 'react-icons/md'
import { IoMdSettings } from 'react-icons/io'
import { FaStudiovinari } from 'react-icons/fa'
import './Sidebar.css'

function Sidebar({ isOpen }) {
  const navigate = useNavigate()
  const [activeItem, setActiveItem] = useState(null)

  const menuItems = [
    { icon: AiFillHome, label: 'Home', path: '/', description: 'Community highlights, featured battles' },
    { icon: BsMusicNote, label: 'Tribal Arena', path: '/tribal-arena', description: 'Battle types, leaderboards' },
    { icon: FaStudiovinari, label: 'Studio', path: '/studio', description: 'Collaborative DAW and editing tools' },
    { icon: MdLeaderboard, label: 'Leaderboards', path: '/leaderboards', description: 'Rankings for producers and tracks' },
    { icon: MdFavorite, label: 'Favorites', path: '/favorites', description: 'Saved beats, bookmarked content' },
    { icon: BsPeople, label: 'Community', path: '/community', description: 'Forums, spotlights, discussions' },
    { icon: AiFillStar, label: 'Spotlight Producer', path: '/spotlight', description: 'Top producers or tracks' },
    { icon: IoMdSettings, label: 'Settings', path: '/settings', description: 'User account management' }
  ]

  const handleNavigation = (path, index) => {
    setActiveItem(index)
    navigate(path)
  }

  return (
    <aside className={`sidebar ${!isOpen ? 'collapsed' : ''}`}>
      <div className="sidebar-content">
        {menuItems.map((item, index) => (
          <div 
            key={index} 
            className={`sidebar-item ${activeItem === index ? 'active' : ''}`}
            data-tooltip={item.description}
            onClick={() => handleNavigation(item.path, index)}
          >
            <div className="sidebar-item-icon">
              <item.icon />
            </div>
            <span className="sidebar-item-label">{item.label}</span>
          </div>
        ))}
      </div>
    </aside>
  )
}

export default Sidebar
