import React, { useState } from 'react';
import './ChallengeModal.css';

function ChallengeModal({ isVisible, onClose, onSubmit }) {
  const [opponent, setOpponent] = useState('');
  const [genre, setGenre] = useState('Hip Hop');
  const [duration, setDuration] = useState('30 Minutes');
  const [customMessage, setCustomMessage] = useState('');

  if (!isVisible) return null;

  const handleSubmit = async (e) => {
    e.preventDefault();

    const challengeData = {
      challengerId: 123, // Replace with actual user ID
      challengedId: opponent, // Replace with selected opponent ID
      genre,
      duration,
      responseDeadline: new Date(Date.now() + 24 * 60 * 60 * 1000).toISOString(),
      message: customMessage,
    };

    try {
      await onSubmit(challengeData);
      alert('Challenge sent successfully!');
      onClose();
    } catch (error) {
      console.error('Error sending challenge:', error);
      alert('Failed to send challenge. Please try again.');
    }
  };

  return (
    <div className="modal-backdrop">
      <div className="modal-content">
        <h2>Challenge a Producer</h2>
        <form onSubmit={handleSubmit}>
          {/* Opponent */}
          <label>
            <strong>Opponent Username:</strong>
            <input
              type="text"
              value={opponent}
              onChange={(e) => setOpponent(e.target.value)}
              placeholder="Enter opponent username"
              required
            />
          </label>

          {/* Genre */}
          <label>
            <strong>Select Genre:</strong>
            <select value={genre} onChange={(e) => setGenre(e.target.value)}>
              <option value="Hip Hop">Hip Hop</option>
              <option value="Trap">Trap</option>
              <option value="Lo-Fi">Lo-Fi</option>
              <option value="R&B">R&B</option>
            </select>
          </label>

          {/* Duration */}
          <label>
            <strong>Challenge Duration:</strong>
            <select value={duration} onChange={(e) => setDuration(e.target.value)}>
              <option value="30 Minutes">30 Minutes</option>
              <option value="1 Hour">1 Hour</option>
              <option value="24 Hours">24 Hours</option>
            </select>
          </label>

          {/* Custom Message */}
          <label>
            <strong>Custom Message:</strong>
            <textarea
              value={customMessage}
              onChange={(e) => setCustomMessage(e.target.value)}
              placeholder="Add a custom message (optional)"
            />
          </label>

          <div className="modal-actions">
            <button type="submit" className="btn-submit">Send Challenge</button>
            <button type="button" className="btn-cancel" onClick={onClose}>Cancel</button>
          </div>
        </form>
      </div>
    </div>
  );
}

export default ChallengeModal;
