import React, { useState } from 'react';
import './JoinBattleModal.css';

function JoinBattleModal({ isOpen, onClose }) {
  const [selectedBattle, setSelectedBattle] = useState(null);

  const availableBattles = [
    { id: 1, name: 'Hip Hop Showdown', status: 'LIVE', genre: 'Hip Hop' },
    { id: 2, name: 'Trap Clash', status: 'Voting', genre: 'Trap' },
  ];

  const handleJoin = () => {
    if (selectedBattle) {
      alert(`You joined the battle: ${selectedBattle.name}`);
      onClose();
    } else {
      alert('Please select a battle to join.');
    }
  };

  if (!isOpen) return null;

  return (
    <div className="join-battle-modal">
      <div className="modal-content">
        <h2>Join a Battle</h2>
        <ul>
          {availableBattles.map((battle) => (
            <li key={battle.id}>
              <label>
                <input
                  type="radio"
                  name="battle"
                  value={battle.id}
                  onChange={() => setSelectedBattle(battle)}
                />
                {battle.name} - {battle.genre} ({battle.status})
              </label>
            </li>
          ))}
        </ul>
        <div className="modal-actions">
          <button className="btn-secondary" onClick={onClose}>
            Cancel
          </button>
          <button className="btn-primary" onClick={handleJoin}>
            Join
          </button>
        </div>
      </div>
    </div>
  );
}

export default JoinBattleModal;
