import React, { useState } from 'react'
import { FaFire, FaTrophy } from 'react-icons/fa'
import './LeaderboardPanel.css'

function LeaderboardPanel() {
  const [activeFilter, setActiveFilter] = useState('fire')

  const leaderboardData = {
    fire: [
      { rank: 1, name: 'Producer X', score: 2345, genre: 'Hip Hop' },
      { rank: 2, name: 'Producer Y', score: 2156, genre: 'Trap' },
      { rank: 3, name: 'Producer Z', score: 1987, genre: 'R&B' }
    ],
    wins: [
      { rank: 1, name: 'Producer A', score: 45, genre: 'Hip Hop' },
      { rank: 2, name: 'Producer B', score: 38, genre: 'Lo-Fi' },
      { rank: 3, name: 'Producer C', score: 32, genre: 'Trap' }
    ]
  }

  return (
    <div className="leaderboard-panel">
      <h2>Leaderboards</h2>
      
      <div className="leaderboard-filters">
        <button 
          className={`filter-btn ${activeFilter === 'fire' ? 'active' : ''}`}
          onClick={() => setActiveFilter('fire')}
        >
          <FaFire /> Top Fire
        </button>
        <button 
          className={`filter-btn ${activeFilter === 'wins' ? 'active' : ''}`}
          onClick={() => setActiveFilter('wins')}
        >
          <FaTrophy /> Most Wins
        </button>
      </div>

      <div className="leaderboard-list">
        {leaderboardData[activeFilter].map((producer) => (
          <div key={producer.rank} className="leaderboard-item">
            <span className="rank">#{producer.rank}</span>
            <div className="producer-info">
              <span className="name">{producer.name}</span>
              <span className="genre">{producer.genre}</span>
            </div>
            <span className="score">
              {activeFilter === 'fire' ? (
                <><FaFire /> {producer.score}</>
              ) : (
                <><FaTrophy /> {producer.score}</>
              )}
            </span>
          </div>
        ))}
      </div>
    </div>
  )
}

export default LeaderboardPanel
