import React, { useState } from 'react';
import './StartBattleModal.css';

function StartBattleModal({ isOpen, onClose, onSubmit }) {
  // Mock data for challengers and genres
  const mockUsers = [
    { id: 1, name: 'User A' },
    { id: 2, name: 'User B' },
    { id: 3, name: 'User C' },
  ];

  const genres = [
    'Hip Hop',
    'Trap',
    'Lo-Fi',
    'Pop',
    'R&B',
    'Rock',
    'Electronic',
  ];

  const [challengerId, setChallengerId] = useState('');
  const [genre, setGenre] = useState('');
  const [duration, setDuration] = useState('30min');
  const [beatFile, setBeatFile] = useState(null);

  if (!isOpen) return null;

  const handleSubmit = (e) => {
    e.preventDefault();

    if (!challengerId || !genre || !beatFile) {
      alert('Please fill out all fields and upload a beat.');
      return;
    }

    onSubmit({
      challengerId,
      genre,
      duration,
      beatFile,
    });

    onClose(); // Close the modal after submission
  };

  return (
    <div className="modal-overlay">
      <div className="modal">
        <h2>Start Battle</h2>
        <form onSubmit={handleSubmit}>
          {/* Select Challenger */}
          <label>
            Select Challenger:
            <select
              value={challengerId}
              onChange={(e) => setChallengerId(e.target.value)}
            >
              <option value="">-- Select a Challenger --</option>
              {mockUsers.map((user) => (
                <option key={user.id} value={user.id}>
                  {user.name}
                </option>
              ))}
            </select>
          </label>

          {/* Genre */}
          <label>
            Genre:
            <select value={genre} onChange={(e) => setGenre(e.target.value)}>
              <option value="">-- Select Genre --</option>
              {genres.map((genre, index) => (
                <option key={index} value={genre}>
                  {genre}
                </option>
              ))}
            </select>
          </label>

          {/* Duration */}
          <label>
            Duration:
            <select value={duration} onChange={(e) => setDuration(e.target.value)}>
              <option value="30min">30 Minutes</option>
              <option value="1hr">1 Hour</option>
              <option value="24hr">24 Hours</option>
            </select>
          </label>

          {/* Upload Beat */}
          <label>
            Upload Beat:
            <input type="file" onChange={(e) => setBeatFile(e.target.files[0])} />
          </label>

          <div className="modal-actions">
            <button type="submit" className="btn-primary">
              Start Battle
            </button>
            <button type="button" className="btn-secondary" onClick={onClose}>
              Cancel
            </button>
          </div>
        </form>
      </div>
    </div>
  );
}

export default StartBattleModal;
