import React, { useState } from 'react'
import { FaFire } from 'react-icons/fa'
import './VotingSystem.css'

function VotingSystem({ battleId, producerId }) {
  const [fireRating, setFireRating] = useState(0)
  const [hasVoted, setHasVoted] = useState(false)

  const handleVote = (rating) => {
    if (!hasVoted) {
      setFireRating(rating)
      setHasVoted(true)
      // Here we would send the vote to the backend
      console.log(`Voted ${rating} fire for producer ${producerId} in battle ${battleId}`)
    }
  }

  return (
    <div className="voting-system">
      <div className="fire-rating">
        {[1, 2, 3, 4, 5].map((rating) => (
          <button
            key={rating}
            className={`fire-btn ${rating <= fireRating ? 'active' : ''}`}
            onClick={() => handleVote(rating)}
            disabled={hasVoted}
          >
            <FaFire />
          </button>
        ))}
      </div>
      {hasVoted && (
        <div className="vote-message">
          Thanks for voting! 🔥
        </div>
      )}
    </div>
  )
}

export default VotingSystem
