import React from 'react'
import { FaFolder, FaMusic, FaDrum } from 'react-icons/fa'
import './Library.css'

function Library() {
  const sampleLibrary = {
    'Drums': [
      { name: 'Kick 1', type: 'audio' },
      { name: 'Snare 1', type: 'audio' },
      { name: 'Hi-Hat 1', type: 'audio' }
    ],
    'Bass': [
      { name: '808 Bass', type: 'audio' },
      { name: 'Sub Bass', type: 'audio' }
    ],
    'Melodies': [
      { name: 'Piano Loop', type: 'audio' },
      { name: 'Synth Lead', type: 'audio' }
    ]
  }

  return (
    <div className="library">
      <div className="library-header">
        <h3>Library</h3>
        <button className="upload-btn">
          Upload
        </button>
      </div>

      <div className="library-content">
        {Object.entries(sampleLibrary).map(([category, items]) => (
          <div key={category} className="library-category">
            <div className="category-header">
              <FaFolder />
              <span>{category}</span>
            </div>
            <div className="category-items">
              {items.map((item, index) => (
                <div key={index} className="library-item">
                  <FaMusic />
                  <span>{item.name}</span>
                </div>
              ))}
            </div>
          </div>
        ))}
      </div>
    </div>
  )
}

export default Library
