import React from 'react'
import { FaVolumeMute, FaHeadphones } from 'react-icons/fa'
import './MixerPanel.css'

function MixerPanel({ tracks, onUpdateTrack }) {
  const handleVolumeChange = (trackId, e) => {
    onUpdateTrack(trackId, { volume: parseFloat(e.target.value) })
  }

  const handlePanChange = (trackId, e) => {
    onUpdateTrack(trackId, { pan: parseFloat(e.target.value) })
  }

  const toggleMute = (trackId) => {
    const track = tracks.find(t => t.id === trackId)
    onUpdateTrack(trackId, { muted: !track.muted })
  }

  const toggleSolo = (trackId) => {
    const track = tracks.find(t => t.id === trackId)
    onUpdateTrack(trackId, { solo: !track.solo })
  }

  return (
    <div className="mixer-panel">
      {tracks.map(track => (
        <div key={track.id} className="mixer-track">
          <div className="mixer-track-header">
            <input
              type="text"
              value={track.name}
              onChange={(e) => onUpdateTrack(track.id, { name: e.target.value })}
              className="mixer-track-name"
            />
            <div className="mixer-track-controls">
              <button 
                className={`mixer-track-btn ${track.muted ? 'active' : ''}`}
                onClick={() => toggleMute(track.id)}
              >
                <FaVolumeMute />
              </button>
              <button 
                className={`mixer-track-btn ${track.solo ? 'active' : ''}`}
                onClick={() => toggleSolo(track.id)}
              >
                <FaHeadphones />
              </button>
            </div>
          </div>
          <div className="mixer-track-fader">
            <input
              type="range"
              min="-100"
              max="0"
              value={track.volume}
              onChange={(e) => handleVolumeChange(track.id, e)}
              className="volume-slider"
            />
          </div>
          <div className="mixer-track-pan">
            <input
              type="range"
              min="-100"
              max="100"
              value={track.pan}
              onChange={(e) => handlePanChange(track.id, e)}
              className="pan-slider"
            />
          </div>
        </div>
      ))}
    </div>
  )
}

export default MixerPanel
