import React from 'react'
import './ProjectSettingsPanel.css'

function ProjectSettingsPanel({ settings, onSettingsChange }) {
  const handleInputChange = (settingName, value) => {
    onSettingsChange({ ...settings, [settingName]: value })
  }

  return (
    <div className="project-settings-panel">
      <h3>Project Settings</h3>
      <div className="setting-item">
        <label htmlFor="project-name">Project Name:</label>
        <input
          type="text"
          id="project-name"
          value={settings.name}
          onChange={(e) => handleInputChange('name', e.target.value)}
        />
      </div>
      <div className="setting-item">
        <label htmlFor="bpm">Tempo (BPM):</label>
        <input
          type="number"
          id="bpm"
          min="20"
          max="300"
          value={settings.bpm}
          onChange={(e) => handleInputChange('bpm', parseInt(e.target.value))}
        />
      </div>
      <div className="setting-item">
        <label htmlFor="time-signature">Time Signature:</label>
        <select
          id="time-signature"
          value={settings.timeSignature}
          onChange={(e) => handleInputChange('timeSignature', e.target.value)}
        >
          <option value="4/4">4/4</option>
          <option value="3/4">3/4</option>
          <option value="6/8">6/8</option>
          <option value="12/8">12/8</option>
        </select>
      </div>
    </div>
  )
}

export default ProjectSettingsPanel
