import React, { useState } from 'react'
import { FaFolder, FaFileAudio } from 'react-icons/fa'
import './SampleBrowser.css'

function SampleBrowser({ onSampleSelect }) {
  const [samples] = useState({
    'Drums': [
      { name: 'Kick 01', type: 'audio', path: '/samples/drums/kick01.wav' },
      { name: 'Snare 01', type: 'audio', path: '/samples/drums/snare01.wav' },
      { name: 'Hi-Hat 01', type: 'audio', path: '/samples/drums/hihat01.wav' }
    ],
    'Bass': [
      { name: '808 Bass', type: 'audio', path: '/samples/bass/808.wav' },
      { name: 'Sub Bass', type: 'audio', path: '/samples/bass/sub.wav' }
    ],
    'Melodies': [
      { name: 'Piano Loop', type: 'audio', path: '/samples/melodies/piano.wav' },
      { name: 'Synth Lead', type: 'audio', path: '/samples/melodies/synth.wav' }
    ]
  })

  const handleDragStart = (event, sample) => {
    event.dataTransfer.setData('sample', JSON.stringify(sample))
  }

  return (
    <div className="sample-browser">
      <div className="library-header">
        <h3>Sample Browser</h3>
      </div>

      <div className="library-content">
        {Object.entries(samples).map(([category, items]) => (
          <div key={category} className="library-category">
            <div className="category-header">
              <FaFolder />
              <span>{category}</span>
            </div>
            <div className="category-items">
              {items.map((item, index) => (
                <div 
                  key={index} 
                  className="library-item"
                  draggable
                  onDragStart={(event) => handleDragStart(event, item)}
                >
                  <FaFileAudio />
                  <span>{item.name}</span>
                </div>
              ))}
            </div>
          </div>
        ))}
      </div>
    </div>
  )
}

export default SampleBrowser
