import React from 'react'
import Grid from './Grid'
import './Timeline.css'

function Timeline({ currentTime, collaborators }) {
  const renderTimeMarkers = () => {
    const markers = []
    for (let i = 0; i < 60; i++) {
      markers.push(
        <div key={i} className="time-marker">
          <span>{i}</span>
        </div>
      )
    }
    return markers
  }

  return (
    <div className="timeline">
      <div className="time-markers">
        {renderTimeMarkers()}
      </div>
      
      <Grid />

      <div className="collaborator-cursors">
        {collaborators.map(user => (
          <div
            key={user.id}
            className="collaborator-cursor"
            style={{
              left: `${user.cursor}px`,
              backgroundColor: user.color
            }}
          >
            <span className="collaborator-name">{user.name}</span>
          </div>
        ))}
      </div>
      
      <div 
        className="playhead"
        style={{ left: `${currentTime}px` }}
      />
    </div>
  )
}

export default Timeline
