import React from 'react'
import { 
  FaPlus, 
  FaCut, 
  FaCopy, 
  FaPaste, 
  FaUndo, 
  FaRedo,
  FaCloudUploadAlt,
  FaSoundcloud,
  FaSlidersH,
  FaFolder,
  FaCog
} from 'react-icons/fa'
import './ToolBar.css'

function ToolBar({ onAddTrack, onToggleEffects, onToggleSampleBrowser, onToggleProjectSettings }) {
  return (
    <div className="toolbar">
      <div className="tool-group">
        <button className="tool-btn" onClick={onAddTrack}>
          <FaPlus />
          <span>Add Track</span>
        </button>
        <button className="tool-btn">
          <FaCut />
          <span>Cut</span>
        </button>
        <button className="tool-btn">
          <FaCopy />
          <span>Copy</span>
        </button>
        <button className="tool-btn">
          <FaPaste />
          <span>Paste</span>
        </button>
      </div>

      <div className="tool-group">
        <button className="tool-btn">
          <FaUndo />
          <span>Undo</span>
        </button>
        <button className="tool-btn">
          <FaRedo />
          <span>Redo</span>
        </button>
      </div>

      <div className="tool-group">
        <button className="tool-btn">
          <FaCloudUploadAlt />
          <span>Save</span>
        </button>
        <button className="tool-btn">
          <FaSoundcloud />
          <span>Publish</span>
        </button>
      </div>

      <div className="tool-group">
        <button className="tool-btn" onClick={onToggleEffects}>
          <FaSlidersH />
          <span>Effects</span>
        </button>
        <button className="tool-btn" onClick={onToggleSampleBrowser}>
          <FaFolder />
          <span>Samples</span>
        </button>
        <button className="tool-btn" onClick={onToggleProjectSettings}>
          <FaCog />
          <span>Settings</span>
        </button>
      </div>
    </div>
  )
}

export default ToolBar
