import React from 'react'
import { FaVolumeMute, FaHeadphones, FaTrash } from 'react-icons/fa'
import Waveform from './Waveform'
import './Track.css'

function Track({ track, onUpdate, currentTime }) {
  const handleVolumeChange = (e) => {
    onUpdate({ volume: parseFloat(e.target.value) })
  }

  const handlePanChange = (e) => {
    onUpdate({ pan: parseFloat(e.target.value) })
  }

  const toggleMute = () => {
    onUpdate({ muted: !track.muted })
  }

  const toggleSolo = () => {
    onUpdate({ solo: !track.solo })
  }

  return (
    <div className="track" style={{ '--track-color': track.color }}>
      <div className="track-header">
        <input
          type="text"
          value={track.name}
          onChange={(e) => onUpdate({ name: e.target.value })}
          className="track-name"
        />
        <div className="track-controls">
          <button 
            className={`track-btn ${track.muted ? 'active' : ''}`}
            onClick={toggleMute}
          >
            <FaVolumeMute />
          </button>
          <button 
            className={`track-btn ${track.solo ? 'active' : ''}`}
            onClick={toggleSolo}
          >
            <FaHeadphones />
          </button>
          <input
            type="range"
            min="-100"
            max="0"
            value={track.volume}
            onChange={handleVolumeChange}
            className="volume-slider"
          />
          <input
            type="range"
            min="-100"
            max="100"
            value={track.pan}
            onChange={handlePanChange}
            className="pan-slider"
          />
        </div>
      </div>
      
      <div className="track-content">
        <div className="track-waveform">
          <Waveform track={track} currentTime={currentTime} />
        </div>
      </div>
    </div>
  )
}

export default Track
