import React from 'react'
import Track from './Track'
import './TrackList.css'

function TrackList({ tracks, setTracks, currentTime, onDropSample }) {
  const handleTrackUpdate = (trackId, updates) => {
    setTracks(tracks.map(track => 
      track.id === trackId ? { ...track, ...updates } : track
    ))
  }

  const handleDrop = (event, trackId) => {
    event.preventDefault()
    const sample = JSON.parse(event.dataTransfer.getData('sample'))
    onDropSample(trackId, sample)
  }

  const handleDragOver = (event) => {
    event.preventDefault()
  }

  return (
    <div className="track-list-container">
      <div className="track-list">
        {tracks.length === 0 ? (
          <div className="track-list-empty">
            No tracks added. Click the "Add Track" button to get started.
          </div>
        ) : (
          tracks.map(track => (
            <div
              key={track.id}
              className="track-drop-zone"
              onDrop={(event) => handleDrop(event, track.id)}
              onDragOver={handleDragOver}
            >
              <Track
                key={track.id}
                track={track}
                onUpdate={(updates) => handleTrackUpdate(track.id, updates)}
                currentTime={currentTime}
              />
            </div>
          ))
        )}
      </div>
    </div>
  )
}

export default TrackList
