import React from 'react'
import { FaPlay, FaPause, FaStop, FaCircle, FaStepBackward, FaStepForward } from 'react-icons/fa'
import './Transport.css'

function Transport({ isPlaying, setIsPlaying, isRecording, setIsRecording, currentTime, setCurrentTime, bpm, setBpm }) {
  const togglePlayback = () => {
    setIsPlaying(!isPlaying)
    if (isRecording) {
      setIsRecording(false)
    }
  }

  const toggleRecording = () => {
    setIsRecording(!isRecording)
    if (isPlaying) {
      setIsPlaying(false)
    }
  }

  const stop = () => {
    setIsPlaying(false)
    setIsRecording(false)
    setCurrentTime(0)
  }

  const handleBpmChange = (e) => {
    setBpm(parseInt(e.target.value))
  }

  const formatTime = (time) => {
    const minutes = Math.floor(time / 60)
    const seconds = Math.floor(time % 60)
    return `${minutes}:${seconds.toString().padStart(2, '0')}`
  }

  return (
    <div className="transport">
      <div className="transport-controls">
        <button className="transport-btn">
          <FaStepBackward />
        </button>
        <button className="transport-btn" onClick={togglePlayback}>
          {isPlaying ? <FaPause /> : <FaPlay />}
        </button>
        <button className="transport-btn" onClick={toggleRecording}>
          {isRecording ? <FaPause /> : <FaCircle />}
        </button>
        <button className="transport-btn" onClick={stop}>
          <FaStop />
        </button>
        <button className="transport-btn">
          <FaStepForward />
        </button>
      </div>
      
      <div className="transport-time">
        <span>{formatTime(currentTime)}</span>
      </div>
      
      <div className="transport-tempo">
        <input
          type="number"
          value={bpm}
          min="20"
          max="300"
          className="tempo-input"
          onChange={handleBpmChange}
        />
        <span>BPM</span>
      </div>
    </div>
  )
}

export default Transport
