import React, { useEffect, useRef } from 'react'
import './Waveform.css'

function Waveform({ track, currentTime }) {
  const canvasRef = useRef(null)

  useEffect(() => {
    const canvas = canvasRef.current
    const ctx = canvas.getContext('2d')
    const width = canvas.width
    const height = canvas.height

    // Simulate audio data (replace with actual audio data when available)
    const generateWaveformData = (trackId, length) => {
      const data = []
      for (let i = 0; i < length; i++) {
        const baseValue = Math.sin(i * 0.02 + trackId * 0.5) // Different base for each track
        const variation = Math.random() * 0.5 + 0.5 // Random variation
        data.push(baseValue * variation)
      }
      return data
    }

    const waveformData = generateWaveformData(track.id, width)

    // Draw waveform
    const drawWaveform = () => {
      ctx.clearRect(0, 0, width, height)
      ctx.beginPath()
      ctx.moveTo(0, height / 2)

      for (let i = 0; i < width; i++) {
        const amplitude = waveformData[i] * height / 2
        const y = height / 2 - amplitude
        ctx.lineTo(i, y)
      }

      ctx.strokeStyle = track.color
      ctx.stroke()
    }

    drawWaveform()
  }, [track])

  useEffect(() => {
    const canvas = canvasRef.current
    const ctx = canvas.getContext('2d')
    const width = canvas.width
    const height = canvas.height

    // Draw playhead
    const drawPlayhead = () => {
      ctx.clearRect(0, 0, width, height)
      ctx.beginPath()
      ctx.moveTo(currentTime, 0)
      ctx.lineTo(currentTime, height)
      ctx.strokeStyle = '#fff'
      ctx.lineWidth = 2
      ctx.stroke()
    }

    drawPlayhead()
  }, [currentTime])

  return (
    <canvas ref={canvasRef} className="waveform-canvas" width="600" height="100"></canvas>
  )
}

export default Waveform
