// mockData.js

export const mockBattles = {
  directChallenge: {
    id: 1,
    type: 'Direct Challenge',
    status: 'LIVE',
    genre: 'Hip Hop',
    roundInfo: 'Final Round',
    viewers: 1234,
    timeLeft: '12:30',
    prizePool: 1000,
    producer1: {
      id: 1,
      name: 'Producer A',
      track: '/tracks/producer-a.mp3',
      votes: 234,
      rank: 'gold',
      xp: 1500,
      wins: 25
    },
    producer2: {
      id: 2,
      name: 'Producer B',
      track: '/tracks/producer-b.mp3',
      votes: 187,
      rank: 'silver',
      xp: 950,
      wins: 15
    }
  },

  communityBattle: {
    id: 2,
    type: 'Community Battle',
    status: 'VOTING',
    genre: 'Trap',
    roundInfo: 'Round 1',
    viewers: 856,
    timeLeft: '45:00',
    submissionTimeLeft: '2 days',
    prizePool: 500,
    participants: [
      {
        id: 1,
        name: 'Producer X',
        track: '/tracks/producer-x.mp3',
        votes: 156,
        rank: 'platinum',
        xp: 2500,
        wins: 45
      },
      {
        id: 2,
        name: 'Producer Y',
        track: '/tracks/producer-y.mp3',
        votes: 145,
        rank: 'gold',
        xp: 1800,
        wins: 30
      },
      {
        id: 3,
        name: 'Producer Z',
        track: '/tracks/producer-z.mp3',
        votes: 132,
        rank: 'silver',
        xp: 1200,
        wins: 20
      }
    ]
  },

  tournament: {
    id: 3,
    type: 'Tournament',
    status: 'LIVE',
    genre: 'Hip Hop',
    prizePool: 5000,
    currentRound: 2,
    totalRounds: 3,
    tournament: {
      name: 'Summer Producer Championship'
    },
    currentMatches: [
      {
        id: 1,
        producer1: {
          id: 1,
          name: 'Producer A',
          track: '/tracks/producer-a.mp3',
          votes: 345,
          rank: 'diamond',
          xp: 3500,
          wins: 75
        },
        producer2: {
          id: 2,
          name: 'Producer B',
          track: '/tracks/producer-b.mp3',
          votes: 289,
          rank: 'platinum',
          xp: 2800,
          wins: 52
        }
      },
      {
        id: 2,
        producer1: {
          id: 3,
          name: 'Producer C',
          track: '/tracks/producer-c.mp3',
          votes: 267,
          rank: 'gold',
          xp: 1900,
          wins: 35
        },
        producer2: {
          id: 4,
          name: 'Producer D',
          track: '/tracks/producer-d.mp3',
          votes: 234,
          rank: 'gold',
          xp: 1750,
          wins: 31
        }
      }
    ]
  }
};

export const mockMessages = [
  {
    id: 1,
    user: 'User123',
    text: 'This beat is 🔥',
    timestamp: '2024-01-26T12:00:00Z'
  },
  {
    id: 2,
    user: 'Producer',
    text: 'Thanks fam! More heat coming 🎵',
    timestamp: '2024-01-26T12:01:00Z'
  },
  {
    id: 3,
    user: 'BeatMaker99',
    text: 'Love that sample flip',
    timestamp: '2024-01-26T12:02:00Z'
  }
];